/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.idwsf.profile.config;

import com.google.common.base.Predicates;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.saml.saml2.profile.config.BrowserSSOProfileConfiguration;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.opensaml.profile.context.ProfileRequestContext;

public class SSOSProfileConfiguration
extends BrowserSSOProfileConfiguration {
    @Nonnull
    @NotEmpty
    public static final String PROFILE_ID = "http://shibboleth.net/ns/profiles/liberty/ssos";
    @Nonnull
    private Predicate<ProfileRequestContext> delegationPredicate = Predicates.alwaysFalse();

    public SSOSProfileConfiguration() {
        this(PROFILE_ID);
    }

    protected SSOSProfileConfiguration(@Nonnull @NotEmpty String profileId) {
        super(profileId);
    }

    public boolean isDelegation(@Nullable ProfileRequestContext profileRequestContext) {
        return this.delegationPredicate.test(profileRequestContext);
    }

    public void setDelegation(boolean flag) {
        this.delegationPredicate = flag ? Predicates.alwaysTrue() : Predicates.alwaysFalse();
    }

    public void setDelegationPredicate(@Nonnull Predicate<ProfileRequestContext> predicate) {
        this.delegationPredicate = (Predicate)Constraint.isNotNull(predicate, (String)"Delegation predicate cannot be null");
    }
}

