/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.metadata;

import java.util.Locale;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.shibboleth.utilities.java.support.annotation.constraint.Unmodifiable;
import org.opensaml.saml.saml2.metadata.AttributeConsumingService;
import org.opensaml.saml.saml2.metadata.LocalizedName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ACSUIInfo {
    private static final Logger LOG = LoggerFactory.getLogger(ACSUIInfo.class);
    @Nonnull
    @Unmodifiable
    private final Map<Locale, String> serviceNames;
    @Nonnull
    @Unmodifiable
    private final Map<Locale, String> serviceDescriptions;
    private final Predicate<LocalizedName> nullLanguageString = new Predicate<LocalizedName>(){

        @Override
        public boolean test(LocalizedName u) {
            if (u.getXMLLang() == null) {
                LOG.warn("String with value {} has no language associated, ignoring", (Object)u.getValue());
                return false;
            }
            return true;
        }
    };

    public ACSUIInfo(@Nonnull AttributeConsumingService acs) {
        this.serviceNames = acs.getNames().stream().filter(this.nullLanguageString).collect(Collectors.toUnmodifiableMap(serviceName -> Locale.forLanguageTag(serviceName.getXMLLang()), serviceName -> serviceName.getValue()));
        this.serviceDescriptions = acs.getDescriptions().stream().filter(this.nullLanguageString).collect(Collectors.toUnmodifiableMap(description -> Locale.forLanguageTag(description.getXMLLang()), description -> description.getValue()));
    }

    @Nonnull
    @Unmodifiable
    public Map<Locale, String> getServiceNames() {
        return this.serviceNames;
    }

    @Nonnull
    @Unmodifiable
    public Map<Locale, String> getServiceDescriptions() {
        return this.serviceDescriptions;
    }
}

