/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.metadata;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.shibboleth.utilities.java.support.annotation.constraint.Unmodifiable;
import org.opensaml.saml.ext.saml2mdui.Keywords;
import org.opensaml.saml.ext.saml2mdui.Logo;
import org.opensaml.saml.ext.saml2mdui.UIInfo;
import org.opensaml.saml.saml2.metadata.LocalizedName;
import org.opensaml.saml.saml2.metadata.LocalizedURI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IdPUIInfo {
    private static final Logger LOG = LoggerFactory.getLogger(IdPUIInfo.class);
    @Nonnull
    @Unmodifiable
    private final Map<Locale, String> displayNames;
    @Nonnull
    @Unmodifiable
    private final Map<Locale, List<String>> keywordList;
    @Nonnull
    @Unmodifiable
    private final Map<Locale, String> descriptions;
    @Nonnull
    @Unmodifiable
    private final Map<Locale, List<Logo>> localeLogos;
    @Nonnull
    @Unmodifiable
    private final List<Logo> nonLocaleLogos;
    @Nonnull
    @Unmodifiable
    private final Map<Locale, String> informationURLs;
    @Nonnull
    @Unmodifiable
    private final Map<Locale, String> privacyStatementURLs;
    private final Predicate<LocalizedURI> nullLanguageURL = new Predicate<LocalizedURI>(){

        @Override
        public boolean test(LocalizedURI u) {
            if (u.getXMLLang() == null) {
                LOG.warn("URI with value {} has no language associated, ignoring", (Object)u.getURI());
                return false;
            }
            return true;
        }
    };
    private final Predicate<LocalizedName> nullLanguageString = new Predicate<LocalizedName>(){

        @Override
        public boolean test(LocalizedName u) {
            if (u.getXMLLang() == null) {
                LOG.warn("String with value {} has no language associated, ignoring", (Object)u.getValue());
                return false;
            }
            return true;
        }
    };
    private final Predicate<Keywords> nullLanguageKeyword = new Predicate<Keywords>(){

        @Override
        public boolean test(Keywords u) {
            if (u.getXMLLang() == null) {
                LOG.warn("String with value {} has no language associated, ignoring", (Object)u.getKeywords().toString());
                return false;
            }
            return true;
        }
    };

    public IdPUIInfo(@Nonnull UIInfo uiInfo) {
        this.displayNames = uiInfo.getDisplayNames().stream().filter(this.nullLanguageString).collect(Collectors.toUnmodifiableMap(displayName -> Locale.forLanguageTag(displayName.getXMLLang()), displayName -> displayName.getValue()));
        this.keywordList = uiInfo.getKeywords().stream().filter(this.nullLanguageKeyword).collect(Collectors.toUnmodifiableMap(keywords -> Locale.forLanguageTag(keywords.getXMLLang()), keywords -> keywords.getKeywords()));
        this.descriptions = uiInfo.getDescriptions().stream().filter(this.nullLanguageString).collect(Collectors.toUnmodifiableMap(description -> Locale.forLanguageTag(description.getXMLLang()), description -> description.getValue()));
        this.informationURLs = uiInfo.getInformationURLs().stream().filter(this.nullLanguageURL).collect(Collectors.toUnmodifiableMap(url -> Locale.forLanguageTag(url.getXMLLang()), dn -> dn.getURI()));
        this.privacyStatementURLs = uiInfo.getPrivacyStatementURLs().stream().filter(this.nullLanguageURL).collect(Collectors.toUnmodifiableMap(url -> Locale.forLanguageTag(url.getXMLLang()), url -> url.getURI()));
        ArrayList<Logo> noLocaleLogo = new ArrayList<Logo>();
        HashMap withLocaleLogo = new HashMap();
        for (Logo logo : uiInfo.getLogos()) {
            if (logo.getXMLLang() != null) {
                Locale l = Locale.forLanguageTag(logo.getXMLLang());
                if (withLocaleLogo.get(l) == null) {
                    withLocaleLogo.put(l, new ArrayList());
                }
                ((List)withLocaleLogo.get(l)).add(logo);
                continue;
            }
            noLocaleLogo.add(logo);
        }
        this.localeLogos = Collections.unmodifiableMap(withLocaleLogo);
        this.nonLocaleLogos = Collections.unmodifiableList(noLocaleLogo);
    }

    @Nonnull
    @Unmodifiable
    public Map<Locale, String> getDisplayNames() {
        return this.displayNames;
    }

    @Nonnull
    @Unmodifiable
    public Map<Locale, List<String>> getKeywords() {
        return this.keywordList;
    }

    @Nonnull
    @Unmodifiable
    public Map<Locale, String> getDescriptions() {
        return this.descriptions;
    }

    @Nonnull
    @Unmodifiable
    public Map<Locale, List<Logo>> getLocaleLogos() {
        return this.localeLogos;
    }

    @Nonnull
    @Unmodifiable
    public List<Logo> getNonLocaleLogos() {
        return this.nonLocaleLogos;
    }

    @Nonnull
    @Unmodifiable
    public Map<Locale, String> getInformationURLs() {
        return this.informationURLs;
    }

    @Nonnull
    @Unmodifiable
    public Map<Locale, String> getPrivacyStatementURLs() {
        return this.privacyStatementURLs;
    }
}

