/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.metadata;

import java.util.Locale;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.shibboleth.utilities.java.support.annotation.constraint.Unmodifiable;
import org.opensaml.saml.saml2.metadata.LocalizedName;
import org.opensaml.saml.saml2.metadata.LocalizedURI;
import org.opensaml.saml.saml2.metadata.Organization;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OrganizationUIInfo {
    private static final Logger LOG = LoggerFactory.getLogger(OrganizationUIInfo.class);
    @Nonnull
    @Unmodifiable
    private final Map<Locale, String> organizationNames;
    @Nonnull
    @Unmodifiable
    private final Map<Locale, String> displayNames;
    @Nonnull
    @Unmodifiable
    private final Map<Locale, String> urls;
    private final Predicate<LocalizedName> nullLanguageString = new Predicate<LocalizedName>(){

        @Override
        public boolean test(LocalizedName u) {
            if (u.getXMLLang() == null) {
                LOG.warn("String with value {} has no language associated, ignoring", (Object)u.getValue());
                return false;
            }
            return true;
        }
    };
    private final Predicate<LocalizedURI> nullLanguageURL = new Predicate<LocalizedURI>(){

        @Override
        public boolean test(LocalizedURI u) {
            if (u.getXMLLang() == null) {
                LOG.warn("URI with value {} has no language associated, ignoring", (Object)u.getURI());
                return false;
            }
            return true;
        }
    };

    public OrganizationUIInfo(@Nonnull Organization organization) {
        this.organizationNames = organization.getOrganizationNames().stream().filter(this.nullLanguageString).collect(Collectors.toUnmodifiableMap(serviceName -> Locale.forLanguageTag(serviceName.getXMLLang()), serviceName -> serviceName.getValue()));
        this.displayNames = organization.getDisplayNames().stream().filter(this.nullLanguageString).collect(Collectors.toUnmodifiableMap(description -> Locale.forLanguageTag(description.getXMLLang()), description -> description.getValue()));
        this.urls = organization.getURLs().stream().filter(this.nullLanguageURL).collect(Collectors.toUnmodifiableMap(url -> Locale.forLanguageTag(url.getXMLLang()), dn -> dn.getURI()));
    }

    @Nonnull
    @Unmodifiable
    public Map<Locale, String> getOrganizationNames() {
        return this.organizationNames;
    }

    @Nonnull
    @Unmodifiable
    public Map<Locale, String> getOrganizationDisplayNames() {
        return this.displayNames;
    }

    @Nonnull
    @Unmodifiable
    public Map<Locale, String> getOrganizationUrls() {
        return this.urls;
    }
}

