/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.metadata;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.primitive.StringSupport;

public class ScopesContainer {
    @Nonnull
    private Set<String> simpleScopes = Collections.emptySet();
    @Nonnull
    private List<Predicate<String>> regexpScopes = Collections.emptyList();

    public void setSimpleScopes(@Nullable Set<String> scopes) {
        this.simpleScopes = scopes == null || scopes.isEmpty() ? Collections.emptySet() : scopes.stream().map(StringSupport::trimOrNull).filter(e -> null != e).collect(Collectors.toSet());
    }

    public void setRegexpScopes(@Nullable Set<String> scopes) {
        this.regexpScopes = scopes == null || scopes.isEmpty() ? Collections.emptyList() : scopes.stream().filter(e -> null != e).map(Pattern::compile).map(Pattern::asMatchPredicate).collect(Collectors.toList());
    }

    public boolean matchesScope(@Nonnull @NotEmpty String scope) {
        String strippedScope = StringSupport.trimOrNull((String)scope);
        Constraint.isNotNull((Object)strippedScope, (String)"ScopesContainer#matchesScope() requires non null or empty Scope");
        if (this.simpleScopes.contains(strippedScope)) {
            return true;
        }
        for (Predicate<String> p : this.regexpScopes) {
            if (!p.test(strippedScope)) continue;
            return true;
        }
        return false;
    }
}

