/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.profile.config;

import com.google.common.base.Predicates;
import java.time.Duration;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.profile.config.AbstractConditionalProfileConfiguration;
import net.shibboleth.idp.saml.profile.config.SAMLProfileConfiguration;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.annotation.constraint.NotLive;
import net.shibboleth.utilities.java.support.annotation.constraint.Unmodifiable;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.logic.FunctionSupport;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSAMLProfileConfiguration
extends AbstractConditionalProfileConfiguration
implements SAMLProfileConfiguration {
    @Nonnull
    public static final Duration DEFAULT_ASSERTION_LIFETIME = Duration.ofMinutes(5L);
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(AbstractSAMLProfileConfiguration.class);
    @Nonnull
    private Predicate<ProfileRequestContext> signRequestsPredicate = Predicates.alwaysFalse();
    @Nonnull
    private Predicate<ProfileRequestContext> signResponsesPredicate = Predicates.alwaysFalse();
    @Nonnull
    private Predicate<ProfileRequestContext> signAssertionsPredicate = Predicates.alwaysFalse();
    @Nonnull
    private Predicate<ProfileRequestContext> includeNotBeforePredicate = Predicates.alwaysTrue();
    @Nonnull
    private Function<ProfileRequestContext, Duration> assertionLifetimeLookupStrategy = FunctionSupport.constant((Object)DEFAULT_ASSERTION_LIFETIME);
    @Nonnull
    private Function<ProfileRequestContext, Set<String>> assertionAudiencesLookupStrategy = FunctionSupport.constant(null);

    public AbstractSAMLProfileConfiguration(@Nonnull @NotEmpty String profileId) {
        super(profileId);
    }

    @Nonnull
    @NonnullElements
    @NotLive
    @Unmodifiable
    public List<String> getInboundInterceptorFlows(@Nullable ProfileRequestContext profileRequestContext) {
        List flows = super.getInboundInterceptorFlows(profileRequestContext);
        if (flows.isEmpty()) {
            this.log.warn("Inbound interceptor collection is empty, this disables default inbound message security checks");
        }
        return flows;
    }

    @Override
    public boolean isSignAssertions(@Nullable ProfileRequestContext profileRequestContext) {
        return this.signAssertionsPredicate.test(profileRequestContext);
    }

    public void setSignAssertions(boolean flag) {
        this.signAssertionsPredicate = flag ? Predicates.alwaysTrue() : Predicates.alwaysFalse();
    }

    public void setSignAssertionsPredicate(@Nonnull Predicate<ProfileRequestContext> predicate) {
        this.signAssertionsPredicate = (Predicate)Constraint.isNotNull(predicate, (String)"Condition cannot be null");
    }

    @Override
    public boolean isSignRequests(@Nullable ProfileRequestContext profileRequestContext) {
        return this.signRequestsPredicate.test(profileRequestContext);
    }

    public void setSignRequests(boolean flag) {
        this.signRequestsPredicate = flag ? Predicates.alwaysTrue() : Predicates.alwaysFalse();
    }

    public void setSignRequestsPredicate(@Nonnull Predicate<ProfileRequestContext> predicate) {
        this.signRequestsPredicate = (Predicate)Constraint.isNotNull(predicate, (String)"Condition cannot be null");
    }

    @Override
    public boolean isSignResponses(@Nullable ProfileRequestContext profileRequestContext) {
        return this.signResponsesPredicate.test(profileRequestContext);
    }

    public void setSignResponses(boolean flag) {
        this.signResponsesPredicate = flag ? Predicates.alwaysTrue() : Predicates.alwaysFalse();
    }

    public void setSignResponsesPredicate(@Nonnull Predicate<ProfileRequestContext> predicate) {
        this.signResponsesPredicate = (Predicate)Constraint.isNotNull(predicate, (String)"Condition cannot be null");
    }

    @Override
    @Nonnull
    public Duration getAssertionLifetime(@Nullable ProfileRequestContext profileRequestContext) {
        Duration lifetime = this.assertionLifetimeLookupStrategy.apply(profileRequestContext);
        Constraint.isNotNull((Object)lifetime, (String)"Assertion lifetime cannot be null");
        Constraint.isFalse((lifetime.isNegative() || lifetime.isZero() ? 1 : 0) != 0, (String)"Assertion lifetime must be greater than 0");
        return lifetime;
    }

    public void setAssertionLifetime(@Nonnull Duration lifetime) {
        Constraint.isNotNull((Object)lifetime, (String)"Assertion lifetime cannot be null");
        Constraint.isFalse((lifetime.isNegative() || lifetime.isZero() ? 1 : 0) != 0, (String)"Assertion lifetime must be greater than 0");
        this.assertionLifetimeLookupStrategy = FunctionSupport.constant((Object)lifetime);
    }

    public void setAssertionLifetimeLookupStrategy(@Nonnull Function<ProfileRequestContext, Duration> strategy) {
        this.assertionLifetimeLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Lookup strategy cannot be null");
    }

    @Override
    public boolean isIncludeConditionsNotBefore(@Nullable ProfileRequestContext profileRequestContext) {
        return this.includeNotBeforePredicate.test(profileRequestContext);
    }

    public void setIncludeConditionsNotBefore(boolean flag) {
        this.includeNotBeforePredicate = flag ? Predicates.alwaysTrue() : Predicates.alwaysFalse();
    }

    public void setIncludeConditionsNotBeforePredicate(@Nonnull Predicate<ProfileRequestContext> condition) {
        this.includeNotBeforePredicate = (Predicate)Constraint.isNotNull(condition, (String)"Condition cannot be null");
    }

    @Override
    @Nonnull
    @NonnullElements
    @NotLive
    public Set<String> getAdditionalAudiencesForAssertion(@Nullable ProfileRequestContext profileRequestContext) {
        Set<String> audiences = this.assertionAudiencesLookupStrategy.apply(profileRequestContext);
        if (audiences != null) {
            return Set.copyOf(audiences);
        }
        return Collections.emptySet();
    }

    public void setAdditionalAudiencesForAssertion(@Nullable @NonnullElements Collection<String> audiences) {
        this.assertionAudiencesLookupStrategy = audiences == null || audiences.isEmpty() ? FunctionSupport.constant(null) : FunctionSupport.constant(Set.copyOf(StringSupport.normalizeStringCollection(audiences)));
    }

    public void setAdditionalAudiencesForAssertionLookupStrategy(@Nonnull Function<ProfileRequestContext, Set<String>> strategy) {
        this.assertionAudiencesLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Lookup strategy cannot be null");
    }
}

