/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.profile.config;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.attribute.IdPAttribute;
import net.shibboleth.idp.attribute.IdPAttributeValue;
import net.shibboleth.idp.attribute.StringAttributeValue;
import net.shibboleth.idp.saml.profile.config.AbstractMetadataDrivenConfigurationLookupStrategy;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullAfterInit;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.schema.XSAny;
import org.opensaml.core.xml.schema.XSString;
import org.opensaml.saml.saml2.core.Attribute;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class BeanConfigurationLookupStrategy<T>
extends AbstractMetadataDrivenConfigurationLookupStrategy<T>
implements ApplicationContextAware {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(BeanConfigurationLookupStrategy.class);
    @Nullable
    private ApplicationContext applicationContext;
    @NonnullAfterInit
    private Class<T> propertyType;

    public BeanConfigurationLookupStrategy() {
        this.setEnableCaching(false);
    }

    public void setPropertyType(@Nonnull Class<T> type) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.propertyType = (Class)Constraint.isNotNull(type, (String)"Property type cannot be null");
    }

    public void setApplicationContext(ApplicationContext context) throws BeansException {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.applicationContext = context;
    }

    @Override
    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.propertyType == null || this.applicationContext == null) {
            throw new ComponentInitializationException("Property type and Spring ApplicationContext cannot be null");
        }
    }

    @Override
    @Nullable
    protected T doTranslate(@Nonnull IdPAttribute tag) {
        List values = tag.getValues();
        if (values.size() != 1) {
            this.log.error("Tag '{}' contained multiple values, returning none", (Object)tag.getId());
            return null;
        }
        this.log.debug("Converting tag '{}' to Bean property of tyoe '{}'", (Object)tag.getId(), (Object)this.propertyType.getSimpleName());
        IdPAttributeValue value = (IdPAttributeValue)values.get(0);
        if (value instanceof StringAttributeValue) {
            try {
                return (T)this.applicationContext.getBean(((StringAttributeValue)value).getValue(), this.propertyType);
            }
            catch (BeansException e) {
                this.log.error("Error locating appropriately typed bean named {}", (Object)((StringAttributeValue)value).getValue(), (Object)e);
                return null;
            }
        }
        this.log.error("Tag '{}' contained non-string value, returning null");
        return null;
    }

    @Override
    @Nullable
    protected T doTranslate(@Nonnull Attribute tag) {
        List values = tag.getAttributeValues();
        if (values.size() != 1) {
            this.log.error("Tag '{}' contained multiple values, returning none", (Object)tag.getName());
            return null;
        }
        this.log.debug("Converting tag '{}' to Bean property of tyoe '{}'", (Object)tag.getName(), (Object)this.propertyType.getSimpleName());
        return this.xmlObjectToBean((XMLObject)values.get(0));
    }

    @Nullable
    private T xmlObjectToBean(@Nonnull XMLObject object) {
        XSAny wc;
        String value = null;
        if (object instanceof XSString) {
            value = ((XSString)object).getValue();
        } else if (object instanceof XSAny && (wc = (XSAny)object).getUnknownAttributes().isEmpty() && wc.getUnknownXMLObjects().isEmpty()) {
            value = wc.getTextContent();
        }
        if (value != null) {
            try {
                return (T)this.applicationContext.getBean(value, this.propertyType);
            }
            catch (BeansException e) {
                this.log.error("Error locating appropriately typed bean named {}", (Object)value, (Object)e);
                return null;
            }
        }
        this.log.error("Unsupported conversion to Spring bean from XMLObject type ({})", (Object)object.getClass().getName());
        return null;
    }
}

