/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.profile.config;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.attribute.IdPAttribute;
import net.shibboleth.idp.attribute.IdPAttributeValue;
import net.shibboleth.idp.attribute.StringAttributeValue;
import net.shibboleth.idp.saml.profile.config.AbstractMetadataDrivenConfigurationLookupStrategy;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.schema.XSAny;
import org.opensaml.core.xml.schema.XSBoolean;
import org.opensaml.core.xml.schema.XSBooleanValue;
import org.opensaml.core.xml.schema.XSInteger;
import org.opensaml.core.xml.schema.XSString;
import org.opensaml.saml.saml2.core.Attribute;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BooleanConfigurationLookupStrategy
extends AbstractMetadataDrivenConfigurationLookupStrategy<Boolean> {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(BooleanConfigurationLookupStrategy.class);

    @Override
    @Nullable
    protected Boolean doTranslate(@Nonnull IdPAttribute tag) {
        List values = tag.getValues();
        if (values.size() != 1) {
            this.log.error("Tag '{}' contained multiple values, returning none", (Object)tag.getId());
            return null;
        }
        this.log.debug("Converting tag '{}' to Boolean property", (Object)tag.getId());
        IdPAttributeValue value = (IdPAttributeValue)values.get(0);
        if (value instanceof StringAttributeValue) {
            return XSBooleanValue.valueOf((String)((StringAttributeValue)value).getValue()).getValue();
        }
        this.log.error("Tag '{}' contained non-string value, returning null");
        return null;
    }

    @Override
    @Nullable
    protected Boolean doTranslate(@Nonnull Attribute tag) {
        List values = tag.getAttributeValues();
        if (values.size() != 1) {
            this.log.error("Tag '{}' contained multiple values, returning none", (Object)tag.getName());
            return null;
        }
        this.log.debug("Converting tag '{}' to Boolean property", (Object)tag.getName());
        return this.xmlObjectToBoolean((XMLObject)values.get(0));
    }

    @Nullable
    private Boolean xmlObjectToBoolean(@Nonnull XMLObject object) {
        XSAny wc;
        if (object instanceof XSString) {
            String value = ((XSString)object).getValue();
            if (value != null) {
                return XSBooleanValue.valueOf((String)value).getValue();
            }
            return null;
        }
        if (object instanceof XSBoolean) {
            XSBooleanValue value = ((XSBoolean)object).getValue();
            return value != null ? value.getValue() : null;
        }
        if (object instanceof XSInteger) {
            Integer value = ((XSInteger)object).getValue();
            return value != null ? Boolean.valueOf(value != 0) : null;
        }
        if (object instanceof XSAny && (wc = (XSAny)object).getUnknownAttributes().isEmpty() && wc.getUnknownXMLObjects().isEmpty()) {
            String value = wc.getTextContent();
            if (value != null) {
                return XSBooleanValue.valueOf((String)value).getValue();
            }
            return null;
        }
        this.log.error("Unsupported conversion to Boolean from XMLObject type ({})", (Object)object.getClass().getName());
        return null;
    }
}

