/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.profile.config;

import java.time.Instant;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.attribute.IdPAttribute;
import net.shibboleth.idp.attribute.IdPAttributeValue;
import net.shibboleth.idp.attribute.StringAttributeValue;
import net.shibboleth.idp.saml.profile.config.AbstractMetadataDrivenConfigurationLookupStrategy;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.schema.XSAny;
import org.opensaml.core.xml.schema.XSBoolean;
import org.opensaml.core.xml.schema.XSBooleanValue;
import org.opensaml.core.xml.schema.XSDateTime;
import org.opensaml.core.xml.schema.XSInteger;
import org.opensaml.core.xml.schema.XSString;
import org.opensaml.saml.saml2.core.Attribute;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LongConfigurationLookupStrategy
extends AbstractMetadataDrivenConfigurationLookupStrategy<Long> {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(LongConfigurationLookupStrategy.class);

    @Override
    @Nullable
    protected Long doTranslate(@Nonnull IdPAttribute tag) {
        List values = tag.getValues();
        if (values.size() != 1) {
            this.log.error("Tag '{}' contained multiple values, returning none", (Object)tag.getId());
            return null;
        }
        this.log.debug("Converting tag '{}' to Long property", (Object)tag.getId());
        IdPAttributeValue value = (IdPAttributeValue)values.get(0);
        if (value instanceof StringAttributeValue) {
            return Long.decode(((StringAttributeValue)value).getValue());
        }
        this.log.error("Tag '{}' contained non-string value, returning null");
        return null;
    }

    @Override
    @Nullable
    protected Long doTranslate(@Nonnull Attribute tag) {
        List values = tag.getAttributeValues();
        if (values.size() != 1) {
            this.log.error("Tag '{}' contained multiple values, returning none", (Object)tag.getName());
            return null;
        }
        this.log.debug("Converting tag '{}' to Long property", (Object)tag.getName());
        return this.xmlObjectToLong((XMLObject)values.get(0));
    }

    @Nullable
    private Long xmlObjectToLong(@Nonnull XMLObject object) {
        XSAny wc;
        if (object instanceof XSString) {
            String value = ((XSString)object).getValue();
            return value != null ? Long.decode(value) : null;
        }
        if (object instanceof XSBoolean) {
            XSBooleanValue value = ((XSBoolean)object).getValue();
            return value != null ? Long.valueOf(value.getValue() != false ? 1L : 0L) : null;
        }
        if (object instanceof XSInteger) {
            Integer value = ((XSInteger)object).getValue();
            return value != null ? Long.valueOf(value.longValue()) : null;
        }
        if (object instanceof XSDateTime) {
            Instant dt = ((XSDateTime)object).getValue();
            return dt != null ? Long.valueOf(dt.toEpochMilli()) : null;
        }
        if (object instanceof XSAny && (wc = (XSAny)object).getUnknownAttributes().isEmpty() && wc.getUnknownXMLObjects().isEmpty()) {
            String value = wc.getTextContent();
            return value != null ? Long.decode(value) : null;
        }
        this.log.error("Unsupported conversion to Long from XMLObject type ({})", (Object)object.getClass().getName());
        return null;
    }
}

