/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.profile.config;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.attribute.IdPAttribute;
import net.shibboleth.idp.attribute.IdPAttributeValue;
import net.shibboleth.idp.attribute.StringAttributeValue;
import net.shibboleth.idp.saml.profile.config.AbstractCollectionConfigurationLookupStrategy;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.saml.saml2.core.Attribute;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SetConfigurationLookupStrategy<T>
extends AbstractCollectionConfigurationLookupStrategy<T, Set<T>> {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(SetConfigurationLookupStrategy.class);

    @Override
    @Nullable
    protected Set<T> doTranslate(@Nonnull IdPAttribute tag) {
        this.log.debug("Converting tag '{}' to List<{}> property", (Object)tag.getId(), (Object)this.getPropertyType().getSimpleName());
        List values = tag.getValues();
        HashSet result = new HashSet(values.size());
        for (IdPAttributeValue value : values) {
            if (!(value instanceof StringAttributeValue)) continue;
            try {
                result.add(this.createInstanceFromString(((StringAttributeValue)value).getValue()));
            }
            catch (Exception e) {
                this.log.error("Error converting tag value into {}", (Object)this.getPropertyType().getSimpleName(), (Object)e);
            }
        }
        return result;
    }

    @Override
    @Nullable
    protected Set<T> doTranslate(@Nonnull Attribute tag) {
        this.log.debug("Converting tag '{}' to Set<String> property", (Object)tag.getName());
        List values = tag.getAttributeValues();
        HashSet result = new HashSet(values.size());
        for (XMLObject value : values) {
            String converted = this.xmlObjectToString(value);
            if (converted == null) continue;
            try {
                result.add(this.createInstanceFromString(converted));
            }
            catch (Exception e) {
                this.log.error("Error converting tag value into {}", (Object)this.getPropertyType().getSimpleName(), (Object)e);
            }
        }
        return result;
    }
}

