/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.saml1.profile.config;

import com.google.common.base.Predicates;
import java.security.Principal;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.authn.config.AuthenticationProfileConfiguration;
import net.shibboleth.idp.saml.authn.principal.AuthenticationMethodPrincipal;
import net.shibboleth.idp.saml.saml1.profile.config.AbstractSAML1ArtifactAwareProfileConfiguration;
import net.shibboleth.utilities.java.support.annotation.constraint.NonNegative;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.annotation.constraint.NotLive;
import net.shibboleth.utilities.java.support.annotation.constraint.Unmodifiable;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.logic.FunctionSupport;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import org.opensaml.profile.context.ProfileRequestContext;

public class BrowserSSOProfileConfiguration
extends AbstractSAML1ArtifactAwareProfileConfiguration
implements AuthenticationProfileConfiguration {
    @Nonnull
    @NotEmpty
    public static final String PROFILE_ID = "http://shibboleth.net/ns/profiles/saml1/sso/browser";
    @Nonnull
    private Predicate<ProfileRequestContext> resolveAttributesPredicate;
    @Nonnull
    private Predicate<ProfileRequestContext> includeAttributeStatementPredicate;
    @Nonnull
    private Predicate<ProfileRequestContext> forceAuthnPredicate;
    @Nonnull
    private Function<ProfileRequestContext, Collection<AuthenticationMethodPrincipal>> defaultAuthenticationMethodsLookupStrategy;
    @Nonnull
    private Function<ProfileRequestContext, Set<String>> authenticationFlowsLookupStrategy;
    @Nonnull
    private Function<ProfileRequestContext, Collection<String>> postAuthenticationFlowsLookupStrategy;
    @Nonnull
    private Function<ProfileRequestContext, Collection<String>> nameIDFormatPrecedenceLookupStrategy;
    @Nonnull
    private Function<ProfileRequestContext, Integer> proxyCountLookupStrategy;

    public BrowserSSOProfileConfiguration() {
        this(PROFILE_ID);
    }

    protected BrowserSSOProfileConfiguration(@Nonnull @NotEmpty String profileId) {
        super(profileId);
        this.setSignResponses(true);
        this.resolveAttributesPredicate = Predicates.alwaysTrue();
        this.includeAttributeStatementPredicate = Predicates.alwaysFalse();
        this.authenticationFlowsLookupStrategy = FunctionSupport.constant(null);
        this.postAuthenticationFlowsLookupStrategy = FunctionSupport.constant(null);
        this.defaultAuthenticationMethodsLookupStrategy = FunctionSupport.constant(null);
        this.nameIDFormatPrecedenceLookupStrategy = FunctionSupport.constant(null);
        this.forceAuthnPredicate = Predicates.alwaysFalse();
        this.proxyCountLookupStrategy = FunctionSupport.constant(null);
    }

    public boolean isResolveAttributes(@Nullable ProfileRequestContext profileRequestContext) {
        return this.resolveAttributesPredicate.test(profileRequestContext);
    }

    public void setResolveAttributes(boolean flag) {
        this.resolveAttributesPredicate = flag ? Predicates.alwaysTrue() : Predicates.alwaysFalse();
    }

    public void setResolveAttributesPredicate(@Nonnull Predicate<ProfileRequestContext> condition) {
        this.resolveAttributesPredicate = (Predicate)Constraint.isNotNull(condition, (String)"Resolve attributes predicate cannot be null");
    }

    public boolean isIncludeAttributeStatement(@Nullable ProfileRequestContext profileRequestContext) {
        return this.includeAttributeStatementPredicate.test(profileRequestContext);
    }

    public void setIncludeAttributeStatement(boolean flag) {
        this.includeAttributeStatementPredicate = flag ? Predicates.alwaysTrue() : Predicates.alwaysFalse();
    }

    public void setIncludeAttributeStatementPredicate(@Nonnull Predicate<ProfileRequestContext> condition) {
        this.includeAttributeStatementPredicate = (Predicate)Constraint.isNotNull(condition, (String)"Include attribute statement predicate cannot be null");
    }

    public boolean isForceAuthn(@Nullable ProfileRequestContext profileRequestContext) {
        return this.forceAuthnPredicate.test(profileRequestContext);
    }

    public void setForceAuthn(boolean flag) {
        this.forceAuthnPredicate = flag ? Predicates.alwaysTrue() : Predicates.alwaysFalse();
    }

    public void setForceAuthnPredicate(@Nonnull Predicate<ProfileRequestContext> condition) {
        this.forceAuthnPredicate = (Predicate)Constraint.isNotNull(condition, (String)"Forced authentication predicate cannot be null");
    }

    @Nonnull
    @NonnullElements
    @NotLive
    @Unmodifiable
    public List<Principal> getDefaultAuthenticationMethods(@Nullable ProfileRequestContext profileRequestContext) {
        Collection<AuthenticationMethodPrincipal> methods = this.defaultAuthenticationMethodsLookupStrategy.apply(profileRequestContext);
        if (methods != null) {
            return List.copyOf(methods);
        }
        return Collections.emptyList();
    }

    public void setDefaultAuthenticationMethods(@Nullable @NonnullElements Collection<AuthenticationMethodPrincipal> methods) {
        this.defaultAuthenticationMethodsLookupStrategy = methods != null ? FunctionSupport.constant(List.copyOf(methods)) : FunctionSupport.constant(null);
    }

    public void setDefaultAuthenticationMethodsLookupStrategy(@Nonnull Function<ProfileRequestContext, Collection<AuthenticationMethodPrincipal>> strategy) {
        this.defaultAuthenticationMethodsLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Lookup strategy cannot be null");
    }

    @Nonnull
    @NonnullElements
    @NotLive
    @Unmodifiable
    public Set<String> getAuthenticationFlows(@Nullable ProfileRequestContext profileRequestContext) {
        Set<String> flows = this.authenticationFlowsLookupStrategy.apply(profileRequestContext);
        if (flows != null) {
            return Set.copyOf(flows);
        }
        return Collections.emptySet();
    }

    public void setAuthenticationFlows(@Nullable @NonnullElements Collection<String> flows) {
        this.authenticationFlowsLookupStrategy = flows != null ? FunctionSupport.constant(Set.copyOf(StringSupport.normalizeStringCollection(flows))) : FunctionSupport.constant(null);
    }

    public void setAuthenticationFlowsLookupStrategy(@Nonnull Function<ProfileRequestContext, Set<String>> strategy) {
        this.authenticationFlowsLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Lookup strategy cannot be null");
    }

    @Nonnull
    @NonnullElements
    @NotLive
    @Unmodifiable
    public List<String> getPostAuthenticationFlows(@Nullable ProfileRequestContext profileRequestContext) {
        Collection<String> flows = this.postAuthenticationFlowsLookupStrategy.apply(profileRequestContext);
        if (flows != null) {
            return List.copyOf(flows);
        }
        return Collections.emptyList();
    }

    public void setPostAuthenticationFlows(@Nullable @NonnullElements Collection<String> flows) {
        this.postAuthenticationFlowsLookupStrategy = flows != null ? FunctionSupport.constant(List.copyOf(StringSupport.normalizeStringCollection(flows))) : FunctionSupport.constant(null);
    }

    public void setPostAuthenticationFlowsLookupStrategy(@Nonnull Function<ProfileRequestContext, Collection<String>> strategy) {
        this.postAuthenticationFlowsLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Lookup strategy cannot be null");
    }

    @Nonnull
    @NonnullElements
    @NotLive
    @Unmodifiable
    public List<String> getNameIDFormatPrecedence(@Nullable ProfileRequestContext profileRequestContext) {
        Collection<String> formats = this.nameIDFormatPrecedenceLookupStrategy.apply(profileRequestContext);
        if (formats != null) {
            return List.copyOf(formats);
        }
        return Collections.emptyList();
    }

    public void setNameIDFormatPrecedence(@Nonnull @NonnullElements Collection<String> formats) {
        Constraint.isNotNull(formats, (String)"List of formats cannot be null");
        this.nameIDFormatPrecedenceLookupStrategy = FunctionSupport.constant(List.copyOf(StringSupport.normalizeStringCollection(formats)));
    }

    public void setNameIDFormatPrecedenceLookupStrategy(@Nonnull Function<ProfileRequestContext, Collection<String>> strategy) {
        this.nameIDFormatPrecedenceLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Lookup strategy cannot be null");
    }

    @Nullable
    public Integer getProxyCount(@Nullable ProfileRequestContext profileRequestContext) {
        Integer count = this.proxyCountLookupStrategy.apply(profileRequestContext);
        if (count != null) {
            Constraint.isGreaterThanOrEqual((int)0, (int)count, (String)"Proxy count must be greater than or equal to 0");
        }
        return count;
    }

    public void setProxyCount(@Nullable @NonNegative Integer count) {
        if (count != null) {
            Constraint.isGreaterThanOrEqual((int)0, (int)count, (String)"Proxy count must be greater than or equal to 0");
        }
        this.proxyCountLookupStrategy = FunctionSupport.constant((Object)count);
    }

    public void setProxyCountLookupStrategy(@Nonnull Function<ProfileRequestContext, Integer> strategy) {
        this.proxyCountLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Lookup strategy cannot be null");
    }
}

