/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.saml2.profile.config;

import com.google.common.base.Predicates;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.saml.profile.config.AbstractSAMLProfileConfiguration;
import net.shibboleth.idp.saml.saml2.profile.config.SAML2ProfileConfiguration;
import net.shibboleth.utilities.java.support.annotation.constraint.NonNegative;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.annotation.constraint.NotLive;
import net.shibboleth.utilities.java.support.annotation.constraint.Unmodifiable;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.logic.FunctionSupport;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import org.opensaml.profile.context.ProfileRequestContext;

public abstract class AbstractSAML2ProfileConfiguration
extends AbstractSAMLProfileConfiguration
implements SAML2ProfileConfiguration {
    @Nonnull
    private Predicate<ProfileRequestContext> ignoreRequestSignaturesPredicate = Predicates.alwaysFalse();
    @Nonnull
    private Predicate<ProfileRequestContext> encryptionOptionalPredicate = Predicates.alwaysFalse();
    @Nonnull
    private Predicate<ProfileRequestContext> encryptAssertionsPredicate = Predicates.alwaysFalse();
    @Nonnull
    private Predicate<ProfileRequestContext> encryptNameIDsPredicate = Predicates.alwaysFalse();
    @Nonnull
    private Predicate<ProfileRequestContext> encryptAttributesPredicate = Predicates.alwaysFalse();
    @Nonnull
    private Function<ProfileRequestContext, Integer> proxyCountLookupStrategy = FunctionSupport.constant(null);
    @Nonnull
    private Function<ProfileRequestContext, Collection<String>> proxyAudiencesLookupStrategy = FunctionSupport.constant(null);

    public AbstractSAML2ProfileConfiguration(@Nonnull @NotEmpty String profileId) {
        super(profileId);
    }

    @Override
    @Nullable
    public Integer getProxyCount(@Nullable ProfileRequestContext profileRequestContext) {
        Integer count = this.proxyCountLookupStrategy.apply(profileRequestContext);
        if (count != null) {
            Constraint.isGreaterThanOrEqual((int)0, (int)count, (String)"Proxy count must be greater than or equal to 0");
        }
        return count;
    }

    public void setProxyCount(@Nullable @NonNegative Integer count) {
        if (count != null) {
            Constraint.isGreaterThanOrEqual((int)0, (int)count, (String)"Proxy count must be greater than or equal to 0");
        }
        this.proxyCountLookupStrategy = FunctionSupport.constant((Object)count);
    }

    public void setProxyCountLookupStrategy(@Nonnull Function<ProfileRequestContext, Integer> strategy) {
        this.proxyCountLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Lookup strategy cannot be null");
    }

    @Override
    @Nonnull
    @NonnullElements
    @NotLive
    @Unmodifiable
    public Set<String> getProxyAudiences(@Nullable ProfileRequestContext profileRequestContext) {
        Collection<String> audiences = this.proxyAudiencesLookupStrategy.apply(profileRequestContext);
        if (audiences != null) {
            return Set.copyOf(audiences);
        }
        return Collections.emptySet();
    }

    public void setProxyAudiences(@Nullable @NonnullElements Collection<String> audiences) {
        this.proxyAudiencesLookupStrategy = audiences == null || audiences.isEmpty() ? FunctionSupport.constant(null) : FunctionSupport.constant(List.copyOf(StringSupport.normalizeStringCollection(audiences)));
    }

    public void setProxyAudiencesLookupStrategy(@Nonnull Function<ProfileRequestContext, Collection<String>> strategy) {
        this.proxyAudiencesLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Lookup strategy cannot be null");
    }

    @Override
    public boolean isIgnoreRequestSignatures(@Nonnull ProfileRequestContext profileRequestContext) {
        return this.ignoreRequestSignaturesPredicate.test(profileRequestContext);
    }

    public void setIgnoreRequestSignatures(boolean flag) {
        this.ignoreRequestSignaturesPredicate = flag ? Predicates.alwaysTrue() : Predicates.alwaysFalse();
    }

    public void setIgnoreRequestSignaturesPredicate(@Nonnull Predicate<ProfileRequestContext> condition) {
        this.ignoreRequestSignaturesPredicate = (Predicate)Constraint.isNotNull(condition, (String)"Condition cannot be null");
    }

    @Override
    public boolean isEncryptionOptional(@Nullable ProfileRequestContext profileRequestContext) {
        return this.encryptionOptionalPredicate.test(profileRequestContext);
    }

    public void setEncryptionOptional(boolean flag) {
        this.encryptionOptionalPredicate = flag ? Predicates.alwaysTrue() : Predicates.alwaysFalse();
    }

    public void setEncryptionOptionalPredicate(@Nonnull Predicate<ProfileRequestContext> condition) {
        this.encryptionOptionalPredicate = (Predicate)Constraint.isNotNull(condition, (String)"Encryption optional predicate cannot be null");
    }

    @Override
    public boolean isEncryptAssertions(@Nullable ProfileRequestContext profileRequestContext) {
        return this.encryptAssertionsPredicate.test(profileRequestContext);
    }

    public void setEncryptAssertions(boolean flag) {
        this.encryptAssertionsPredicate = flag ? Predicates.alwaysTrue() : Predicates.alwaysFalse();
    }

    public void setEncryptAssertionsPredicate(@Nonnull Predicate<ProfileRequestContext> predicate) {
        this.encryptAssertionsPredicate = (Predicate)Constraint.isNotNull(predicate, (String)"Condition cannot be null");
    }

    @Override
    public boolean isEncryptNameIDs(@Nullable ProfileRequestContext profileRequestContext) {
        return this.encryptNameIDsPredicate.test(profileRequestContext);
    }

    public void setEncryptNameIDs(boolean flag) {
        this.encryptNameIDsPredicate = flag ? Predicates.alwaysTrue() : Predicates.alwaysFalse();
    }

    public void setEncryptNameIDsPredicate(@Nonnull Predicate<ProfileRequestContext> predicate) {
        this.encryptNameIDsPredicate = (Predicate)Constraint.isNotNull(predicate, (String)"Condition cannot be null");
    }

    @Override
    public boolean isEncryptAttributes(@Nullable ProfileRequestContext profileRequestContext) {
        return this.encryptAttributesPredicate.test(profileRequestContext);
    }

    public void setEncryptAttributes(boolean flag) {
        this.encryptAttributesPredicate = flag ? Predicates.alwaysTrue() : Predicates.alwaysFalse();
    }

    public void setEncryptAttributesPredicate(@Nonnull Predicate<ProfileRequestContext> predicate) {
        this.encryptAttributesPredicate = (Predicate)Constraint.isNotNull(predicate, (String)"Condition cannot be null");
    }
}

