/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.saml2.profile.config;

import com.google.common.base.Predicates;
import java.security.Principal;
import java.time.Duration;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.authn.config.AuthenticationProfileConfiguration;
import net.shibboleth.idp.saml.authn.principal.AuthnContextClassRefPrincipal;
import net.shibboleth.idp.saml.profile.config.logic.ProxyAwareForceAuthnPredicate;
import net.shibboleth.idp.saml.saml2.profile.config.AbstractSAML2ArtifactAwareProfileConfiguration;
import net.shibboleth.idp.saml.saml2.profile.config.navigate.ProxyAwareAuthnContextComparisonLookupFunction;
import net.shibboleth.idp.saml.saml2.profile.config.navigate.ProxyAwareDefaultAuthenticationMethodsLookupFunction;
import net.shibboleth.utilities.java.support.annotation.constraint.NonNegative;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.annotation.constraint.NotLive;
import net.shibboleth.utilities.java.support.annotation.constraint.Unmodifiable;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.logic.FunctionSupport;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.saml.saml2.core.AuthnContext;
import org.opensaml.saml.saml2.core.AuthnContextComparisonTypeEnumeration;

public class BrowserSSOProfileConfiguration
extends AbstractSAML2ArtifactAwareProfileConfiguration
implements AuthenticationProfileConfiguration {
    @Nonnull
    @NotEmpty
    public static final String PROFILE_ID = "http://shibboleth.net/ns/profiles/saml2/sso/browser";
    @Nonnull
    public static final Long DEFAULT_DELEGATION_CHAIN_LENGTH = 1L;
    public static final int FEATURE_AUTHNCONTEXT = 1;
    public static final int FEATURE_SCOPING = 2;
    @Nonnull
    private Predicate<ProfileRequestContext> resolveAttributesPredicate;
    @Nonnull
    private Predicate<ProfileRequestContext> includeAttributeStatementPredicate;
    @Nonnull
    private Predicate<ProfileRequestContext> ignoreScoping;
    @Nonnull
    private Predicate<ProfileRequestContext> forceAuthnPredicate;
    @Nonnull
    private Predicate<ProfileRequestContext> checkAddressPredicate;
    @Nonnull
    private Predicate<ProfileRequestContext> skipEndpointValidationWhenSignedPredicate;
    @Nonnull
    private Predicate<ProfileRequestContext> proxiedAuthnInstantPredicate;
    @Nonnull
    private Function<ProfileRequestContext, Duration> maximumSPSessionLifetimeLookupStrategy;
    @Nonnull
    private Function<ProfileRequestContext, Duration> maximumTimeSinceAuthnLookupStrategy;
    @Nonnull
    private Predicate<ProfileRequestContext> allowDelegationPredicate;
    @Nonnull
    private Function<ProfileRequestContext, Long> maximumTokenDelegationChainLengthLookupStrategy;
    @Nonnull
    private Function<ProfileRequestContext, Function<AuthnContext, Collection<Principal>>> authnContextTranslationStrategyLookupStrategy;
    @Nonnull
    private Function<ProfileRequestContext, String> authnContextComparisonLookupStrategy;
    @Nonnull
    private Function<ProfileRequestContext, Collection<AuthnContextClassRefPrincipal>> defaultAuthenticationContextsLookupStrategy;
    @Nonnull
    private Function<ProfileRequestContext, Set<String>> authenticationFlowsLookupStrategy;
    @Nonnull
    private Function<ProfileRequestContext, Collection<String>> postAuthenticationFlowsLookupStrategy;
    @Nonnull
    private Function<ProfileRequestContext, Collection<String>> nameIDFormatPrecedenceLookupStrategy;

    public BrowserSSOProfileConfiguration() {
        this(PROFILE_ID);
    }

    protected BrowserSSOProfileConfiguration(@Nonnull @NotEmpty String profileId) {
        super(profileId);
        this.setSignResponses(true);
        this.setEncryptAssertions(true);
        this.resolveAttributesPredicate = Predicates.alwaysTrue();
        this.includeAttributeStatementPredicate = Predicates.alwaysTrue();
        this.ignoreScoping = Predicates.alwaysFalse();
        this.forceAuthnPredicate = new ProxyAwareForceAuthnPredicate();
        this.checkAddressPredicate = Predicates.alwaysTrue();
        this.skipEndpointValidationWhenSignedPredicate = Predicates.alwaysFalse();
        this.proxiedAuthnInstantPredicate = Predicates.alwaysTrue();
        this.maximumSPSessionLifetimeLookupStrategy = FunctionSupport.constant(null);
        this.maximumTimeSinceAuthnLookupStrategy = FunctionSupport.constant(null);
        this.maximumTokenDelegationChainLengthLookupStrategy = FunctionSupport.constant((Object)DEFAULT_DELEGATION_CHAIN_LENGTH);
        this.allowDelegationPredicate = Predicates.alwaysFalse();
        this.authenticationFlowsLookupStrategy = FunctionSupport.constant(null);
        this.postAuthenticationFlowsLookupStrategy = FunctionSupport.constant(null);
        this.authnContextTranslationStrategyLookupStrategy = FunctionSupport.constant(null);
        this.authnContextComparisonLookupStrategy = new ProxyAwareAuthnContextComparisonLookupFunction();
        this.defaultAuthenticationContextsLookupStrategy = new ProxyAwareDefaultAuthenticationMethodsLookupFunction();
        this.nameIDFormatPrecedenceLookupStrategy = FunctionSupport.constant(null);
    }

    public boolean isResolveAttributes(@Nullable ProfileRequestContext profileRequestContext) {
        return this.resolveAttributesPredicate.test(profileRequestContext);
    }

    public void setResolveAttributes(boolean flag) {
        this.resolveAttributesPredicate = flag ? Predicates.alwaysTrue() : Predicates.alwaysFalse();
    }

    public void setResolveAttributesPredicate(@Nonnull Predicate<ProfileRequestContext> condition) {
        this.resolveAttributesPredicate = (Predicate)Constraint.isNotNull(condition, (String)"Resolve attributes predicate cannot be null");
    }

    public boolean isIncludeAttributeStatement(@Nullable ProfileRequestContext profileRequestContext) {
        return this.includeAttributeStatementPredicate.test(profileRequestContext);
    }

    public void setIncludeAttributeStatement(boolean flag) {
        this.includeAttributeStatementPredicate = flag ? Predicates.alwaysTrue() : Predicates.alwaysFalse();
    }

    public void setIncludeAttributeStatementPredicate(@Nonnull Predicate<ProfileRequestContext> condition) {
        this.includeAttributeStatementPredicate = (Predicate)Constraint.isNotNull(condition, (String)"Include attribute statement predicate cannot be null");
    }

    public boolean isIgnoreScoping(@Nullable ProfileRequestContext profileRequestContext) {
        return this.ignoreScoping.test(profileRequestContext);
    }

    public void setIgnoreScoping(boolean flag) {
        this.ignoreScoping = flag ? Predicates.alwaysTrue() : Predicates.alwaysFalse();
    }

    public void setIgnoreScopingPredicate(@Nonnull Predicate<ProfileRequestContext> condition) {
        this.ignoreScoping = (Predicate)Constraint.isNotNull(condition, (String)"Ignore Scoping condition cannot be null");
    }

    public boolean isForceAuthn(@Nullable ProfileRequestContext profileRequestContext) {
        return this.forceAuthnPredicate.test(profileRequestContext);
    }

    public void setForceAuthn(boolean flag) {
        this.forceAuthnPredicate = flag ? Predicates.alwaysTrue() : Predicates.alwaysFalse();
    }

    public void setForceAuthnPredicate(@Nonnull Predicate<ProfileRequestContext> condition) {
        this.forceAuthnPredicate = (Predicate)Constraint.isNotNull(condition, (String)"Forced authentication predicate cannot be null");
    }

    public boolean isCheckAddress(@Nullable ProfileRequestContext profileRequestContext) {
        return this.checkAddressPredicate.test(profileRequestContext);
    }

    public void setCheckAddress(boolean flag) {
        this.checkAddressPredicate = flag ? Predicates.alwaysTrue() : Predicates.alwaysFalse();
    }

    public void setCheckAddressPredicate(@Nonnull Predicate<ProfileRequestContext> condition) {
        this.checkAddressPredicate = (Predicate)Constraint.isNotNull(condition, (String)"Address checking predicate cannot be null");
    }

    public boolean isSkipEndpointValidationWhenSigned(@Nullable ProfileRequestContext profileRequestContext) {
        return this.skipEndpointValidationWhenSignedPredicate.test(profileRequestContext);
    }

    public void setSkipEndpointValidationWhenSigned(boolean flag) {
        this.skipEndpointValidationWhenSignedPredicate = flag ? Predicates.alwaysTrue() : Predicates.alwaysFalse();
    }

    public void setSkipEndpointValidationWhenSignedPredicate(@Nonnull Predicate<ProfileRequestContext> condition) {
        this.skipEndpointValidationWhenSignedPredicate = (Predicate)Constraint.isNotNull(condition, (String)"Condition cannot be null");
    }

    public boolean isProxiedAuthnInstant(@Nullable ProfileRequestContext profileRequestContext) {
        return this.proxiedAuthnInstantPredicate.test(profileRequestContext);
    }

    public void setProxiedAuthnInstant(boolean flag) {
        this.proxiedAuthnInstantPredicate = flag ? Predicates.alwaysTrue() : Predicates.alwaysFalse();
    }

    public void setProxiedAuthnInstantPredicate(@Nonnull Predicate<ProfileRequestContext> condition) {
        this.proxiedAuthnInstantPredicate = (Predicate)Constraint.isNotNull(condition, (String)"Condition cannot be null");
    }

    @Nullable
    public Duration getMaximumSPSessionLifetime(@Nullable ProfileRequestContext profileRequestContext) {
        Duration lifetime = this.maximumSPSessionLifetimeLookupStrategy.apply(profileRequestContext);
        Constraint.isFalse((lifetime != null && lifetime.isNegative() ? 1 : 0) != 0, (String)"Maximum SP session lifetime must be greater than or equal to 0");
        return lifetime;
    }

    public void setMaximumSPSessionLifetime(@Nullable Duration lifetime) {
        Constraint.isFalse((lifetime != null && lifetime.isNegative() ? 1 : 0) != 0, (String)"Maximum SP session lifetime must be greater than or equal to 0");
        this.maximumSPSessionLifetimeLookupStrategy = FunctionSupport.constant((Object)lifetime);
    }

    public void setMaximumSPSessionLifetimeLookupStrategy(@Nonnull Function<ProfileRequestContext, Duration> strategy) {
        this.maximumSPSessionLifetimeLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Lookup strategy cannot be null");
    }

    @Nullable
    public Duration getMaximumTimeSinceAuthn(@Nullable ProfileRequestContext profileRequestContext) {
        Duration amount = this.maximumTimeSinceAuthnLookupStrategy.apply(profileRequestContext);
        Constraint.isFalse((amount != null && amount.isNegative() ? 1 : 0) != 0, (String)"Maximum time since authentication must be greater than or equal to 0");
        return amount;
    }

    public void setMaximumTimeSinceAuthn(@Nullable Duration amount) {
        Constraint.isFalse((amount != null && amount.isNegative() ? 1 : 0) != 0, (String)"Maximum time since authentication must be greater than or equal to 0");
        this.maximumTimeSinceAuthnLookupStrategy = FunctionSupport.constant((Object)amount);
    }

    public void setMaximumTimeSinceAuthnLookupStrategy(@Nonnull Function<ProfileRequestContext, Duration> strategy) {
        this.maximumTimeSinceAuthnLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Lookup strategy cannot be null");
    }

    @Nonnull
    public boolean isAllowDelegation(@Nullable ProfileRequestContext profileRequestContext) {
        return this.allowDelegationPredicate.test(profileRequestContext);
    }

    public void setAllowDelegation(boolean flag) {
        this.allowDelegationPredicate = flag ? Predicates.alwaysTrue() : Predicates.alwaysFalse();
    }

    public void setAllowDelegationPredicate(@Nonnull Predicate<ProfileRequestContext> predicate) {
        this.allowDelegationPredicate = (Predicate)Constraint.isNotNull(predicate, (String)"Allow delegation predicate cannot be null");
    }

    @NonNegative
    public long getMaximumTokenDelegationChainLength(@Nullable ProfileRequestContext profileRequestContext) {
        Long len = this.maximumTokenDelegationChainLengthLookupStrategy.apply(profileRequestContext);
        Constraint.isNotNull((Object)len, (String)"Delegation chain length cannot be null");
        Constraint.isGreaterThanOrEqual((long)0L, (long)len, (String)"Delegation chain length must be greater than or equal to 0");
        return len;
    }

    public void setMaximumTokenDelegationChainLength(@NonNegative long length) {
        Constraint.isGreaterThanOrEqual((long)0L, (long)length, (String)"Delegation chain length must be greater than or equal to 0");
        this.maximumTokenDelegationChainLengthLookupStrategy = FunctionSupport.constant((Object)length);
    }

    public void setMaximumTokenDelegationChainLengthLookupStrategy(@Nonnull Function<ProfileRequestContext, Long> strategy) {
        this.maximumTokenDelegationChainLengthLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Lookup strategy cannot be null");
    }

    @Nullable
    public Function<AuthnContext, Collection<Principal>> getAuthnContextTranslationStrategy(@Nullable ProfileRequestContext profileRequestContext) {
        return this.authnContextTranslationStrategyLookupStrategy.apply(profileRequestContext);
    }

    public void setAuthnContextTranslationStrategy(@Nullable Function<AuthnContext, Collection<Principal>> strategy) {
        this.authnContextTranslationStrategyLookupStrategy = FunctionSupport.constant(strategy);
    }

    public void setAuthnContextTranslationStrategyLookupStrategy(@Nullable Function<ProfileRequestContext, Function<AuthnContext, Collection<Principal>>> strategy) {
        this.authnContextTranslationStrategyLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Lookup strategy cannot be null");
    }

    @Nullable
    public AuthnContextComparisonTypeEnumeration getAuthnContextComparison(@Nullable ProfileRequestContext profileRequestContext) {
        String comparison = this.authnContextComparisonLookupStrategy.apply(profileRequestContext);
        if (comparison != null) {
            return AuthnContextComparisonTypeEnumeration.valueOf((String)comparison.toUpperCase());
        }
        return null;
    }

    public void setAuthnContextComparison(@Nullable AuthnContextComparisonTypeEnumeration comparison) {
        this.authnContextComparisonLookupStrategy = FunctionSupport.constant((Object)(comparison != null ? comparison.toString() : null));
    }

    public void setAuthnContextComparisonLookupStrategy(@Nonnull Function<ProfileRequestContext, String> strategy) {
        this.authnContextComparisonLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Lookup strategy cannot be null");
    }

    @Nonnull
    @NonnullElements
    @NotLive
    @Unmodifiable
    public List<Principal> getDefaultAuthenticationMethods(@Nullable ProfileRequestContext profileRequestContext) {
        Collection<AuthnContextClassRefPrincipal> methods = this.defaultAuthenticationContextsLookupStrategy.apply(profileRequestContext);
        if (methods != null) {
            return List.copyOf(methods);
        }
        return Collections.emptyList();
    }

    public void setDefaultAuthenticationMethods(@Nullable @NonnullElements Collection<AuthnContextClassRefPrincipal> contexts) {
        this.defaultAuthenticationContextsLookupStrategy = contexts != null ? FunctionSupport.constant(List.copyOf(contexts)) : FunctionSupport.constant(null);
    }

    public void setDefaultAuthenticationMethodsLookupStrategy(@Nonnull Function<ProfileRequestContext, Collection<AuthnContextClassRefPrincipal>> strategy) {
        this.defaultAuthenticationContextsLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Lookup strategy cannot be null");
    }

    @Nonnull
    @NonnullElements
    @NotLive
    @Unmodifiable
    public Set<String> getAuthenticationFlows(@Nullable ProfileRequestContext profileRequestContext) {
        Set<String> flows = this.authenticationFlowsLookupStrategy.apply(profileRequestContext);
        if (flows != null) {
            return Set.copyOf(flows);
        }
        return Collections.emptySet();
    }

    public void setAuthenticationFlows(@Nullable @NonnullElements Collection<String> flows) {
        this.authenticationFlowsLookupStrategy = flows != null ? FunctionSupport.constant(Set.copyOf(StringSupport.normalizeStringCollection(flows))) : FunctionSupport.constant(null);
    }

    public void setAuthenticationFlowsLookupStrategy(@Nonnull Function<ProfileRequestContext, Set<String>> strategy) {
        this.authenticationFlowsLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Lookup strategy cannot be null");
    }

    @Nonnull
    @NonnullElements
    @NotLive
    @Unmodifiable
    public List<String> getPostAuthenticationFlows(@Nullable ProfileRequestContext profileRequestContext) {
        Collection<String> flows = this.postAuthenticationFlowsLookupStrategy.apply(profileRequestContext);
        if (flows != null) {
            return List.copyOf(flows);
        }
        return Collections.emptyList();
    }

    public void setPostAuthenticationFlows(@Nullable @NonnullElements Collection<String> flows) {
        this.postAuthenticationFlowsLookupStrategy = flows != null ? FunctionSupport.constant(List.copyOf(StringSupport.normalizeStringCollection(flows))) : FunctionSupport.constant(null);
    }

    public void setPostAuthenticationFlowsLookupStrategy(@Nonnull Function<ProfileRequestContext, Collection<String>> strategy) {
        this.postAuthenticationFlowsLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Lookup strategy cannot be null");
    }

    @Nonnull
    @NonnullElements
    @NotLive
    @Unmodifiable
    public List<String> getNameIDFormatPrecedence(@Nullable ProfileRequestContext profileRequestContext) {
        Collection<String> formats = this.nameIDFormatPrecedenceLookupStrategy.apply(profileRequestContext);
        if (formats != null) {
            return List.copyOf(formats);
        }
        return Collections.emptyList();
    }

    public void setNameIDFormatPrecedence(@Nonnull @NonnullElements Collection<String> formats) {
        Constraint.isNotNull(formats, (String)"List of formats cannot be null");
        this.nameIDFormatPrecedenceLookupStrategy = FunctionSupport.constant(List.copyOf(StringSupport.normalizeStringCollection(formats)));
    }

    public void setNameIDFormatPrecedenceLookupStrategy(@Nonnull Function<ProfileRequestContext, Collection<String>> strategy) {
        this.nameIDFormatPrecedenceLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Lookup strategy cannot be null");
    }
}

