/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.saml2.profile.config;

import com.google.common.base.Predicates;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.saml.saml2.profile.config.AbstractSAML2ArtifactAwareProfileConfiguration;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.annotation.constraint.NotLive;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.logic.FunctionSupport;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.logic.NoIntegrityMessageChannelPredicate;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.profile.logic.NoConfidentialityMessageChannelPredicate;

public class SingleLogoutProfileConfiguration
extends AbstractSAML2ArtifactAwareProfileConfiguration {
    @Nonnull
    @NotEmpty
    public static final String PROFILE_ID = "http://shibboleth.net/ns/profiles/saml2/logout";
    @Nonnull
    private Predicate<MessageContext> signSOAPRequestsPredicate;
    @Nonnull
    private Predicate<MessageContext> clientTLSSOAPRequestsPredicate;
    @Nonnull
    private Function<ProfileRequestContext, Collection<String>> qualifiedNameIDFormatsLookupStrategy;

    public SingleLogoutProfileConfiguration() {
        this(PROFILE_ID);
    }

    protected SingleLogoutProfileConfiguration(@Nonnull @NotEmpty String profileId) {
        super(profileId);
        this.setSignRequestsPredicate((Predicate<ProfileRequestContext>)new org.opensaml.profile.logic.NoIntegrityMessageChannelPredicate());
        this.setSignResponsesPredicate((Predicate<ProfileRequestContext>)new org.opensaml.profile.logic.NoIntegrityMessageChannelPredicate());
        this.setEncryptNameIDsPredicate((Predicate<ProfileRequestContext>)new NoConfidentialityMessageChannelPredicate());
        this.signSOAPRequestsPredicate = new NoIntegrityMessageChannelPredicate();
        this.clientTLSSOAPRequestsPredicate = new NoIntegrityMessageChannelPredicate().negate();
        this.qualifiedNameIDFormatsLookupStrategy = FunctionSupport.constant(null);
    }

    public boolean isSignSOAPRequests(@Nullable MessageContext messageContext) {
        return this.signSOAPRequestsPredicate.test(messageContext);
    }

    public void setSignSOAPRequests(boolean flag) {
        this.signSOAPRequestsPredicate = flag ? Predicates.alwaysTrue() : Predicates.alwaysFalse();
    }

    public void setSignSOAPRequestsPredicate(@Nonnull Predicate<MessageContext> predicate) {
        this.signSOAPRequestsPredicate = (Predicate)Constraint.isNotNull(predicate, (String)"Predicate used to determine SOAP-based signing cannot be null");
    }

    public boolean isClientTLSSOAPRequests(@Nullable MessageContext messageContext) {
        return this.clientTLSSOAPRequestsPredicate.test(messageContext);
    }

    public void setClientTLSSOAPRequests(boolean flag) {
        this.clientTLSSOAPRequestsPredicate = flag ? Predicates.alwaysTrue() : Predicates.alwaysFalse();
    }

    public void setClientTLSSOAPRequestsPredicate(@Nonnull Predicate<MessageContext> predicate) {
        this.clientTLSSOAPRequestsPredicate = (Predicate)Constraint.isNotNull(predicate, (String)"Predicate used to determine SOAP-based client TLS use cannot be null");
    }

    @Nonnull
    @NonnullElements
    @NotLive
    public Collection<String> getQualifiedNameIDFormats(@Nullable ProfileRequestContext profileRequestContext) {
        Collection<String> formats = this.qualifiedNameIDFormatsLookupStrategy.apply(profileRequestContext);
        if (formats != null) {
            return List.copyOf(formats);
        }
        return Collections.emptyList();
    }

    public void setQualifiedNameIDFormats(@Nullable @NonnullElements Collection<String> formats) {
        this.qualifiedNameIDFormatsLookupStrategy = formats == null || formats.isEmpty() ? FunctionSupport.constant(null) : FunctionSupport.constant(List.copyOf(StringSupport.normalizeStringCollection(formats)));
    }

    public void setQualifiedNameIDFormatsLookupStrategy(@Nonnull Function<ProfileRequestContext, Collection<String>> strategy) {
        this.qualifiedNameIDFormatsLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Lookup strategy cannot be null");
    }
}

