/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.saml2.profile.config.logic;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.profile.context.RelyingPartyContext;
import net.shibboleth.idp.profile.logic.AbstractRelyingPartyPredicate;
import net.shibboleth.idp.saml.saml2.profile.config.SAML2ProfileConfiguration;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IgnoreRequestSignaturesPredicate
extends AbstractRelyingPartyPredicate {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(IgnoreRequestSignaturesPredicate.class);

    public boolean test(@Nullable ProfileRequestContext input) {
        RelyingPartyContext rpCtx = (RelyingPartyContext)this.getRelyingPartyContextLookupStrategy().apply(input);
        if (rpCtx == null) {
            this.log.debug("No RelyingPartyContext found, assuming signatures should be checked");
            return false;
        }
        if (rpCtx.getProfileConfig() == null || !(rpCtx.getProfileConfig() instanceof SAML2ProfileConfiguration)) {
            this.log.debug("No SAML 2 profile configuration found, assuming signatures should be checked");
            return false;
        }
        return ((SAML2ProfileConfiguration)rpCtx.getProfileConfig()).isIgnoreRequestSignatures(input);
    }
}

