/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.authn.principal;

import net.shibboleth.idp.saml.authn.principal.AuthnContextClassRefPrincipal;
import net.shibboleth.utilities.java.support.logic.ConstraintViolationException;
import org.opensaml.core.testing.XMLObjectBaseTestCase;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.io.MarshallingException;
import org.opensaml.saml.saml2.core.AuthnContextClassRef;
import org.testng.Assert;
import org.testng.annotations.Test;
import org.w3c.dom.Element;

public class AuthnContextClassRefPrincipalTest
extends XMLObjectBaseTestCase {
    @Test
    public void testInstantiation() throws MarshallingException, CloneNotSupportedException {
        AuthnContextClassRefPrincipal principal = new AuthnContextClassRefPrincipal("urn:oasis:names:tc:SAML:2.0:ac:classes:Kerberos");
        Assert.assertEquals((String)principal.getName(), (String)"urn:oasis:names:tc:SAML:2.0:ac:classes:Kerberos");
        AuthnContextClassRef ref = (AuthnContextClassRef)this.buildXMLObject(AuthnContextClassRef.DEFAULT_ELEMENT_NAME);
        ref.setURI("urn:oasis:names:tc:SAML:2.0:ac:classes:Kerberos");
        Element xml = this.getMarshaller(AuthnContextClassRef.DEFAULT_ELEMENT_NAME).marshall((XMLObject)ref);
        this.assertXMLEquals(xml.getOwnerDocument(), (XMLObject)principal.getAuthnContextClassRef());
        AuthnContextClassRefPrincipal principal2 = principal.clone();
        this.assertXMLEquals(xml.getOwnerDocument(), (XMLObject)principal2.getAuthnContextClassRef());
        try {
            new AuthnContextClassRefPrincipal(null);
            Assert.fail();
        }
        catch (ConstraintViolationException constraintViolationException) {
            // empty catch block
        }
        try {
            new AuthnContextClassRefPrincipal("");
            Assert.fail();
        }
        catch (ConstraintViolationException constraintViolationException) {
            // empty catch block
        }
        try {
            new AuthnContextClassRefPrincipal("   ");
            Assert.fail();
        }
        catch (ConstraintViolationException constraintViolationException) {
            // empty catch block
        }
    }
}

