/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.authn.principal;

import net.shibboleth.idp.saml.authn.principal.AuthnContextDeclRefPrincipal;
import net.shibboleth.utilities.java.support.logic.ConstraintViolationException;
import org.opensaml.core.testing.XMLObjectBaseTestCase;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.io.MarshallingException;
import org.opensaml.saml.saml2.core.AuthnContextDeclRef;
import org.testng.Assert;
import org.testng.annotations.Test;
import org.w3c.dom.Element;

public class AuthnContextDeclRefPrincipalTest
extends XMLObjectBaseTestCase {
    @Test
    public void testInstantiation() throws MarshallingException, CloneNotSupportedException {
        AuthnContextDeclRefPrincipal principal = new AuthnContextDeclRefPrincipal("http://opensaml.org/mydecl");
        Assert.assertEquals((String)principal.getName(), (String)"http://opensaml.org/mydecl");
        AuthnContextDeclRef ref = (AuthnContextDeclRef)this.buildXMLObject(AuthnContextDeclRef.DEFAULT_ELEMENT_NAME);
        ref.setURI("http://opensaml.org/mydecl");
        Element xml = this.getMarshaller(AuthnContextDeclRef.DEFAULT_ELEMENT_NAME).marshall((XMLObject)ref);
        this.assertXMLEquals(xml.getOwnerDocument(), (XMLObject)principal.getAuthnContextDeclRef());
        AuthnContextDeclRefPrincipal principal2 = principal.clone();
        this.assertXMLEquals(xml.getOwnerDocument(), (XMLObject)principal2.getAuthnContextDeclRef());
        try {
            new AuthnContextDeclRefPrincipal(null);
            Assert.fail();
        }
        catch (ConstraintViolationException constraintViolationException) {
            // empty catch block
        }
        try {
            new AuthnContextDeclRefPrincipal("");
            Assert.fail();
        }
        catch (ConstraintViolationException constraintViolationException) {
            // empty catch block
        }
        try {
            new AuthnContextDeclRefPrincipal("   ");
            Assert.fail();
        }
        catch (ConstraintViolationException constraintViolationException) {
            // empty catch block
        }
    }
}

