/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.metadata;

import java.util.Collections;
import java.util.Set;
import net.shibboleth.idp.saml.metadata.ScopesContainer;
import org.testng.Assert;
import org.testng.annotations.Test;

public class ScopesContainerTest {
    @Test
    public void empty() {
        ScopesContainer scopes = new ScopesContainer();
        Assert.assertFalse((boolean)scopes.matchesScope("foo"));
        scopes.setRegexpScopes(null);
        scopes.setSimpleScopes(Collections.emptySet());
        Assert.assertFalse((boolean)scopes.matchesScope("foo"));
        scopes.setRegexpScopes(Set.of(""));
        scopes.setSimpleScopes(Collections.singleton(null));
        Assert.assertFalse((boolean)scopes.matchesScope("foo"));
    }

    @Test
    public void stringOnly() {
        ScopesContainer scopes = new ScopesContainer();
        scopes.setSimpleScopes(Set.of("foo", "bar", "james"));
        Assert.assertFalse((boolean)scopes.matchesScope("jimmy"));
        Assert.assertTrue((boolean)scopes.matchesScope("foo"));
        Assert.assertTrue((boolean)scopes.matchesScope("bar"));
        Assert.assertTrue((boolean)scopes.matchesScope("james"));
    }

    @Test
    public void regexpOnly() {
        ScopesContainer scopes = new ScopesContainer();
        scopes.setRegexpScopes(Set.of("^.*fo.*b$"));
        Assert.assertFalse((boolean)scopes.matchesScope("jimmy"));
        Assert.assertFalse((boolean)scopes.matchesScope("foo"));
        Assert.assertFalse((boolean)scopes.matchesScope("foobd"));
        Assert.assertTrue((boolean)scopes.matchesScope("prefoob"));
        Assert.assertTrue((boolean)scopes.matchesScope("prefooltfb"));
    }

    @Test
    public void both() {
        ScopesContainer scopes = new ScopesContainer();
        scopes.setRegexpScopes(Set.of("^.*fo.*b$"));
        scopes.setSimpleScopes(Set.of("foo", "bar", "james"));
        Assert.assertFalse((boolean)scopes.matchesScope("jimmy"));
        Assert.assertTrue((boolean)scopes.matchesScope("james"));
        Assert.assertTrue((boolean)scopes.matchesScope("foo"));
        Assert.assertFalse((boolean)scopes.matchesScope("foobd"));
        Assert.assertTrue((boolean)scopes.matchesScope("prefoob"));
        Assert.assertTrue((boolean)scopes.matchesScope("prefooltfb"));
    }
}

