/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.profile.config;

import com.google.common.base.Predicates;
import java.time.Duration;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Predicate;
import net.shibboleth.idp.saml.profile.config.AbstractSAMLProfileConfiguration;
import net.shibboleth.utilities.java.support.logic.ConstraintViolationException;
import net.shibboleth.utilities.java.support.logic.FunctionSupport;
import org.testng.Assert;
import org.testng.annotations.Test;

public class AbstractSAMLProfileConfigurationTest {
    @Test
    public void testSignAssertionsCriteria() {
        MockSAMLProfileConfiguration config = new MockSAMLProfileConfiguration();
        config.setSignAssertions(false);
        Assert.assertFalse((boolean)config.isSignAssertions(null));
        try {
            config.setSignAssertionsPredicate(null);
            Assert.fail();
        }
        catch (ConstraintViolationException constraintViolationException) {
            // empty catch block
        }
    }

    @Test
    public void testSignResponsesCriteria() {
        MockSAMLProfileConfiguration config = new MockSAMLProfileConfiguration();
        config.setSignResponses(false);
        Assert.assertFalse((boolean)config.isSignResponses(null));
        try {
            config.setSignResponsesPredicate(null);
            Assert.fail();
        }
        catch (ConstraintViolationException constraintViolationException) {
            // empty catch block
        }
    }

    @Test
    public void testSignRequestsCriteria() {
        MockSAMLProfileConfiguration config = new MockSAMLProfileConfiguration();
        config.setSignRequests(false);
        Assert.assertFalse((boolean)config.isSignRequests(null));
        try {
            config.setSignRequestsPredicate(null);
            Assert.fail();
        }
        catch (ConstraintViolationException constraintViolationException) {
            // empty catch block
        }
    }

    @Test
    public void testAssertionLifetime() {
        MockSAMLProfileConfiguration config = new MockSAMLProfileConfiguration();
        Assert.assertTrue((config.getAssertionLifetime(null).toMillis() > 0L ? 1 : 0) != 0);
        config.setAssertionLifetime(Duration.ofMillis(100L));
        Assert.assertEquals((Object)config.getAssertionLifetime(null), (Object)Duration.ofMillis(100L));
        try {
            config.setAssertionLifetime(Duration.ZERO);
            Assert.fail();
        }
        catch (ConstraintViolationException constraintViolationException) {
            // empty catch block
        }
        try {
            config.setAssertionLifetime(Duration.ofMillis(-100L));
            Assert.fail();
        }
        catch (ConstraintViolationException constraintViolationException) {
            // empty catch block
        }
    }

    @Test
    public void testIndirectAssertionLifetime() {
        MockSAMLProfileConfiguration config = new MockSAMLProfileConfiguration();
        config.setAssertionLifetimeLookupStrategy(FunctionSupport.constant((Object)Duration.ofMillis(500L)));
        Assert.assertEquals((Object)config.getAssertionLifetime(null), (Object)Duration.ofMillis(500L));
        config.setAssertionLifetimeLookupStrategy(FunctionSupport.constant(null));
        try {
            config.getAssertionLifetime(null);
            Assert.fail();
        }
        catch (ConstraintViolationException constraintViolationException) {
            // empty catch block
        }
    }

    @Test
    public void testIncludeNotBefore() {
        MockSAMLProfileConfiguration config = new MockSAMLProfileConfiguration();
        Assert.assertTrue((boolean)config.isIncludeConditionsNotBefore(null));
        config.setIncludeConditionsNotBefore(false);
        Assert.assertFalse((boolean)config.isIncludeConditionsNotBefore(null));
    }

    @Test
    public void testIndirectIncludeNotBefore() {
        MockSAMLProfileConfiguration config = new MockSAMLProfileConfiguration();
        config.setIncludeConditionsNotBeforePredicate((Predicate)Predicates.alwaysFalse());
        Assert.assertFalse((boolean)config.isIncludeConditionsNotBefore(null));
    }

    @Test
    public void testAdditionalAudiencesForAssertion() {
        MockSAMLProfileConfiguration config = new MockSAMLProfileConfiguration();
        Assert.assertNotNull((Object)config.getAdditionalAudiencesForAssertion(null));
        Assert.assertTrue((boolean)config.getAdditionalAudiencesForAssertion(null).isEmpty());
        config.setAdditionalAudiencesForAssertion(Arrays.asList("", null, " foo"));
        Set audiences = config.getAdditionalAudiencesForAssertion(null);
        Assert.assertNotNull((Object)audiences);
        Assert.assertEquals((int)audiences.size(), (int)1);
        Assert.assertTrue((boolean)audiences.contains("foo"));
        try {
            audiences.add("bar");
            Assert.fail();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        config.setAdditionalAudiencesForAssertion(null);
        Assert.assertNotNull((Object)config.getAdditionalAudiencesForAssertion(null));
        Assert.assertTrue((boolean)config.getAdditionalAudiencesForAssertion(null).isEmpty());
    }

    @Test
    public void testIndirectAudiencesForAssertion() {
        MockSAMLProfileConfiguration config = new MockSAMLProfileConfiguration();
        HashSet<String> audiences = new HashSet<String>();
        audiences.add("foo");
        audiences.add("bar");
        config.setAdditionalAudiencesForAssertionLookupStrategy(FunctionSupport.constant(audiences));
        Assert.assertEquals((Set)config.getAdditionalAudiencesForAssertion(null), audiences);
    }

    private static class MockSAMLProfileConfiguration
    extends AbstractSAMLProfileConfiguration {
        public MockSAMLProfileConfiguration() {
            super("mock");
        }
    }
}

