/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.profile.logic;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.shibboleth.idp.profile.testing.RequestContextBuilder;
import net.shibboleth.idp.saml.profile.logic.DefaultNameIdentifierFormatStrategy;
import net.shibboleth.idp.saml.saml2.profile.config.BrowserSSOProfileConfiguration;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import org.opensaml.core.testing.OpenSAMLInitBaseTestCase;
import org.opensaml.core.xml.config.XMLObjectProviderRegistrySupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.saml.common.SAMLObjectBuilder;
import org.opensaml.saml.common.messaging.context.SAMLMetadataContext;
import org.opensaml.saml.common.messaging.context.SAMLPeerEntityContext;
import org.opensaml.saml.saml2.metadata.EntityDescriptor;
import org.opensaml.saml.saml2.metadata.NameIDFormat;
import org.opensaml.saml.saml2.metadata.RoleDescriptor;
import org.opensaml.saml.saml2.metadata.SPSSODescriptor;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class DefaultNameIdentifierFormatStrategyTest
extends OpenSAMLInitBaseTestCase {
    private SPSSODescriptor role;
    private BrowserSSOProfileConfiguration profileConfig;
    private ProfileRequestContext prc;
    private DefaultNameIdentifierFormatStrategy strategy;

    @BeforeMethod
    public void setUp() throws ComponentInitializationException {
        SAMLObjectBuilder edBuilder = (SAMLObjectBuilder)XMLObjectProviderRegistrySupport.getBuilderFactory().getBuilderOrThrow(EntityDescriptor.DEFAULT_ELEMENT_NAME);
        SAMLObjectBuilder roleBuilder = (SAMLObjectBuilder)XMLObjectProviderRegistrySupport.getBuilderFactory().getBuilderOrThrow(SPSSODescriptor.DEFAULT_ELEMENT_NAME);
        this.profileConfig = new BrowserSSOProfileConfiguration();
        this.prc = new RequestContextBuilder().setRelyingPartyProfileConfigurations(Collections.singletonList(this.profileConfig)).buildProfileRequestContext();
        this.prc.setProfileId("http://shibboleth.net/ns/profiles/saml2/sso/browser");
        EntityDescriptor entity = (EntityDescriptor)edBuilder.buildObject();
        this.role = (SPSSODescriptor)roleBuilder.buildObject();
        entity.getRoleDescriptors().add(this.role);
        ((SAMLMetadataContext)((SAMLPeerEntityContext)this.prc.getInboundMessageContext().getSubcontext(SAMLPeerEntityContext.class, true)).getSubcontext(SAMLMetadataContext.class, true)).setEntityDescriptor(entity);
        ((SAMLMetadataContext)((SAMLPeerEntityContext)this.prc.getInboundMessageContext().getSubcontext(SAMLPeerEntityContext.class)).getSubcontext(SAMLMetadataContext.class)).setRoleDescriptor((RoleDescriptor)entity.getRoleDescriptors().get(0));
        this.strategy = new DefaultNameIdentifierFormatStrategy();
    }

    @Test
    public void testNoConfiguration() {
        ProfileRequestContext context = new ProfileRequestContext();
        List formats = this.strategy.apply(context);
        Assert.assertEquals((Collection)formats, Collections.singletonList("urn:oasis:names:tc:SAML:1.1:nameid-format:unspecified"));
    }

    @Test
    public void testNoFormats() {
        List formats = this.strategy.apply(this.prc);
        Assert.assertEquals((Collection)formats, Collections.singletonList("urn:oasis:names:tc:SAML:1.1:nameid-format:unspecified"));
    }

    @Test
    public void testNoMetadata() {
        this.profileConfig.setNameIDFormatPrecedence(Arrays.asList("urn:oasis:names:tc:SAML:1.1:nameid-format:emailAddress", "urn:oasis:names:tc:SAML:2.0:nameid-format:transient"));
        List formats = this.strategy.apply(this.prc);
        Assert.assertEquals((Collection)formats, Arrays.asList("urn:oasis:names:tc:SAML:1.1:nameid-format:emailAddress", "urn:oasis:names:tc:SAML:2.0:nameid-format:transient"));
    }

    @Test
    public void testNoProfileConfig() {
        SAMLObjectBuilder formatBuilder = (SAMLObjectBuilder)XMLObjectProviderRegistrySupport.getBuilderFactory().getBuilderOrThrow(NameIDFormat.DEFAULT_ELEMENT_NAME);
        NameIDFormat format = (NameIDFormat)formatBuilder.buildObject();
        format.setURI("urn:oasis:names:tc:SAML:1.1:nameid-format:emailAddress");
        this.role.getNameIDFormats().add(format);
        format = (NameIDFormat)formatBuilder.buildObject();
        format.setURI("urn:oasis:names:tc:SAML:2.0:nameid-format:transient");
        this.role.getNameIDFormats().add(format);
        List formats = this.strategy.apply(this.prc);
        Assert.assertEquals((Collection)formats, Arrays.asList("urn:oasis:names:tc:SAML:1.1:nameid-format:emailAddress", "urn:oasis:names:tc:SAML:2.0:nameid-format:transient"));
    }

    @Test
    public void testNoOverlap() {
        this.profileConfig.setNameIDFormatPrecedence(Arrays.asList("urn:oasis:names:tc:SAML:1.1:nameid-format:emailAddress", "urn:oasis:names:tc:SAML:2.0:nameid-format:transient"));
        SAMLObjectBuilder formatBuilder = (SAMLObjectBuilder)XMLObjectProviderRegistrySupport.getBuilderFactory().getBuilderOrThrow(NameIDFormat.DEFAULT_ELEMENT_NAME);
        NameIDFormat format = (NameIDFormat)formatBuilder.buildObject();
        format.setURI("urn:oasis:names:tc:SAML:2.0:nameid-format:persistent");
        this.role.getNameIDFormats().add(format);
        format = (NameIDFormat)formatBuilder.buildObject();
        format.setURI("urn:oasis:names:tc:SAML:1.1:nameid-format:X509SubjectName");
        this.role.getNameIDFormats().add(format);
        List formats = this.strategy.apply(this.prc);
        Assert.assertTrue((boolean)formats.isEmpty());
    }

    @Test
    public void testOverlap() {
        this.profileConfig.setNameIDFormatPrecedence(Arrays.asList("urn:oasis:names:tc:SAML:1.1:nameid-format:emailAddress", "urn:oasis:names:tc:SAML:2.0:nameid-format:transient"));
        SAMLObjectBuilder formatBuilder = (SAMLObjectBuilder)XMLObjectProviderRegistrySupport.getBuilderFactory().getBuilderOrThrow(NameIDFormat.DEFAULT_ELEMENT_NAME);
        NameIDFormat format = (NameIDFormat)formatBuilder.buildObject();
        format.setURI("urn:oasis:names:tc:SAML:2.0:nameid-format:transient");
        this.role.getNameIDFormats().add(format);
        format = (NameIDFormat)formatBuilder.buildObject();
        format.setURI("urn:oasis:names:tc:SAML:1.1:nameid-format:X509SubjectName");
        this.role.getNameIDFormats().add(format);
        List formats = this.strategy.apply(this.prc);
        Assert.assertEquals((Collection)formats, Collections.singletonList("urn:oasis:names:tc:SAML:2.0:nameid-format:transient"));
    }

    @Test
    public void testUnspecifiedInMetadata() {
        this.profileConfig.setNameIDFormatPrecedence(Arrays.asList("urn:oasis:names:tc:SAML:1.1:nameid-format:emailAddress", "urn:oasis:names:tc:SAML:2.0:nameid-format:transient"));
        SAMLObjectBuilder formatBuilder = (SAMLObjectBuilder)XMLObjectProviderRegistrySupport.getBuilderFactory().getBuilderOrThrow(NameIDFormat.DEFAULT_ELEMENT_NAME);
        NameIDFormat format = (NameIDFormat)formatBuilder.buildObject();
        format.setURI("urn:oasis:names:tc:SAML:2.0:nameid-format:transient");
        this.role.getNameIDFormats().add(format);
        format = (NameIDFormat)formatBuilder.buildObject();
        format.setURI("urn:oasis:names:tc:SAML:1.1:nameid-format:unspecified");
        this.role.getNameIDFormats().add(format);
        List formats = this.strategy.apply(this.prc);
        Assert.assertEquals((Collection)formats, Arrays.asList("urn:oasis:names:tc:SAML:1.1:nameid-format:emailAddress", "urn:oasis:names:tc:SAML:2.0:nameid-format:transient"));
    }
}

