/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.saml1.profile;

import java.util.ArrayList;
import java.util.Collection;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.profile.config.ProfileConfiguration;
import net.shibboleth.idp.profile.config.SecurityConfiguration;
import net.shibboleth.idp.profile.context.RelyingPartyContext;
import net.shibboleth.idp.relyingparty.RelyingPartyConfiguration;
import net.shibboleth.idp.saml.saml1.profile.config.ArtifactResolutionProfileConfiguration;
import net.shibboleth.idp.saml.saml1.profile.config.AttributeQueryProfileConfiguration;
import net.shibboleth.idp.saml.saml1.profile.config.BrowserSSOProfileConfiguration;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import org.opensaml.messaging.context.BaseContext;

public final class SAML1ActionTestingSupport
extends org.opensaml.saml.saml1.testing.SAML1ActionTestingSupport {
    public static RelyingPartyContext buildRelyingPartySubcontext(@Nonnull BaseContext parent, @Nullable String relyingPartyId) throws ComponentInitializationException {
        String id = StringSupport.trimOrNull((String)relyingPartyId);
        if (id == null) {
            id = "http://sp.example.org";
        }
        RelyingPartyConfiguration rpConfig = new RelyingPartyConfiguration();
        rpConfig.setId(id);
        rpConfig.setResponderId("http://idp.example.org");
        rpConfig.setDetailedErrors(true);
        rpConfig.setProfileConfigurations(SAML1ActionTestingSupport.buildProfileConfigurations());
        rpConfig.initialize();
        RelyingPartyContext subcontext = (RelyingPartyContext)parent.getSubcontext(RelyingPartyContext.class, true);
        subcontext.setRelyingPartyId(id);
        subcontext.setProfileConfig(rpConfig.getProfileConfiguration(null, "http://shibboleth.net/ns/profiles/saml1/sso/browser"));
        subcontext.setConfiguration(rpConfig);
        return subcontext;
    }

    public static Collection<ProfileConfiguration> buildProfileConfigurations() {
        ArrayList<ProfileConfiguration> profileConfigs = new ArrayList<ProfileConfiguration>();
        SecurityConfiguration securityConfig = new SecurityConfiguration();
        ArtifactResolutionProfileConfiguration artifactConfig = new ArtifactResolutionProfileConfiguration();
        artifactConfig.setSecurityConfiguration(securityConfig);
        profileConfigs.add((ProfileConfiguration)artifactConfig);
        AttributeQueryProfileConfiguration attributeConfig = new AttributeQueryProfileConfiguration();
        attributeConfig.setSecurityConfiguration(securityConfig);
        profileConfigs.add((ProfileConfiguration)attributeConfig);
        BrowserSSOProfileConfiguration ssoConfig = new BrowserSSOProfileConfiguration();
        ssoConfig.setSecurityConfiguration(securityConfig);
        profileConfigs.add((ProfileConfiguration)ssoConfig);
        return profileConfigs;
    }
}

