/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.saml2.profile.config;

import com.google.common.base.Predicates;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Predicate;
import net.shibboleth.idp.saml.saml2.profile.config.AbstractSAML2ProfileConfiguration;
import net.shibboleth.utilities.java.support.logic.ConstraintViolationException;
import net.shibboleth.utilities.java.support.logic.FunctionSupport;
import org.testng.Assert;
import org.testng.annotations.Test;

public class AbstractSAML2ProfileConfigurationTest {
    @Test
    public void testEncryptionOptional() {
        MockSAML2ProfileConfiguration config = new MockSAML2ProfileConfiguration();
        Assert.assertFalse((boolean)config.isEncryptionOptional(null));
        config.setEncryptionOptional(true);
        Assert.assertTrue((boolean)config.isEncryptionOptional(null));
    }

    @Test
    public void testIndirectEncryptionOptional() {
        MockSAML2ProfileConfiguration config = new MockSAML2ProfileConfiguration();
        config.setEncryptionOptionalPredicate((Predicate)Predicates.alwaysTrue());
        Assert.assertTrue((boolean)config.isEncryptionOptional(null));
    }

    @Test
    public void testEncryptNameIDsPredicate() {
        MockSAML2ProfileConfiguration config = new MockSAML2ProfileConfiguration();
        config.setEncryptNameIDs(true);
        Assert.assertTrue((boolean)config.isEncryptNameIDs(null));
        try {
            config.setEncryptNameIDsPredicate(null);
            Assert.fail();
        }
        catch (ConstraintViolationException constraintViolationException) {
            // empty catch block
        }
    }

    @Test
    public void testEncryptAssertionsPredicate() {
        MockSAML2ProfileConfiguration config = new MockSAML2ProfileConfiguration();
        config.setEncryptAssertions(true);
        Assert.assertTrue((boolean)config.isEncryptAssertions(null));
        try {
            config.setEncryptAssertionsPredicate(null);
            Assert.fail();
        }
        catch (ConstraintViolationException constraintViolationException) {
            // empty catch block
        }
    }

    @Test
    public void testEncryptAttributesPredicate() {
        MockSAML2ProfileConfiguration config = new MockSAML2ProfileConfiguration();
        config.setEncryptAttributes(true);
        Assert.assertTrue((boolean)config.isEncryptAttributes(null));
        try {
            config.setEncryptAttributesPredicate(null);
            Assert.fail();
        }
        catch (ConstraintViolationException constraintViolationException) {
            // empty catch block
        }
    }

    @Test
    public void testProxyCount() {
        MockSAML2ProfileConfiguration config = new MockSAML2ProfileConfiguration();
        Assert.assertNull((Object)config.getProxyCount(null));
        config.setProxyCount(1);
        Assert.assertEquals((Object)config.getProxyCount(null), (Object)1);
    }

    @Test
    public void testIndirectProxyCount() {
        MockSAML2ProfileConfiguration config = new MockSAML2ProfileConfiguration();
        config.setProxyCountLookupStrategy(FunctionSupport.constant((Object)1));
        Assert.assertEquals((Object)config.getProxyCount(null), (Object)1);
    }

    @Test
    public void testProxyAudiences() {
        MockSAML2ProfileConfiguration config = new MockSAML2ProfileConfiguration();
        Assert.assertNotNull((Object)config.getProxyAudiences(null));
        Assert.assertTrue((boolean)config.getProxyAudiences(null).isEmpty());
        HashSet<String> audiences = new HashSet<String>();
        audiences.add("foo");
        audiences.add("bar");
        config.setProxyAudiences(audiences);
        Assert.assertNotSame((Object)config.getProxyAudiences(null), audiences);
        Assert.assertEquals((Set)config.getProxyAudiences(null), audiences);
        try {
            config.getProxyAudiences(null).add("baz");
            Assert.fail();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    @Test
    public void testIndirectProxyAudiences() {
        MockSAML2ProfileConfiguration config = new MockSAML2ProfileConfiguration();
        HashSet<String> audiences = new HashSet<String>();
        audiences.add("foo");
        audiences.add("bar");
        config.setProxyAudiencesLookupStrategy(FunctionSupport.constant(audiences));
        Assert.assertNotSame((Object)config.getProxyAudiences(null), audiences);
        Assert.assertEquals((Set)config.getProxyAudiences(null), audiences);
        try {
            config.getProxyAudiences(null).add("baz");
            Assert.fail();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    private static class MockSAML2ProfileConfiguration
    extends AbstractSAML2ProfileConfiguration {
        public MockSAML2ProfileConfiguration() {
            super("mock");
        }
    }
}

