/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.saml2.profile.config;

import com.google.common.base.Predicates;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Predicate;
import net.shibboleth.idp.saml.authn.principal.AuthnContextClassRefPrincipal;
import net.shibboleth.idp.saml.profile.config.BasicSAMLArtifactConfiguration;
import net.shibboleth.idp.saml.profile.config.SAMLArtifactConfiguration;
import net.shibboleth.idp.saml.saml2.profile.config.BrowserSSOProfileConfiguration;
import net.shibboleth.utilities.java.support.logic.ConstraintViolationException;
import net.shibboleth.utilities.java.support.logic.FunctionSupport;
import org.testng.Assert;
import org.testng.annotations.Test;

public class BrowserSSOProfileConfigurationTest {
    @Test
    public void testProfileId() {
        Assert.assertEquals((String)"http://shibboleth.net/ns/profiles/saml2/sso/browser", (String)"http://shibboleth.net/ns/profiles/saml2/sso/browser");
        BrowserSSOProfileConfiguration config = new BrowserSSOProfileConfiguration();
        Assert.assertEquals((String)config.getId(), (String)"http://shibboleth.net/ns/profiles/saml2/sso/browser");
    }

    @Test
    public void testResolveAttributes() {
        BrowserSSOProfileConfiguration config = new BrowserSSOProfileConfiguration();
        Assert.assertTrue((boolean)config.isResolveAttributes(null));
        config.setResolveAttributes(false);
        Assert.assertFalse((boolean)config.isResolveAttributes(null));
    }

    @Test
    public void testIndirectResolveAttributes() {
        BrowserSSOProfileConfiguration config = new BrowserSSOProfileConfiguration();
        config.setResolveAttributesPredicate((Predicate)Predicates.alwaysFalse());
        Assert.assertFalse((boolean)config.isResolveAttributes(null));
    }

    @Test
    public void testIncludeAttributeStatement() {
        BrowserSSOProfileConfiguration config = new BrowserSSOProfileConfiguration();
        Assert.assertTrue((boolean)config.isIncludeAttributeStatement(null));
        config.setIncludeAttributeStatement(false);
        Assert.assertFalse((boolean)config.isIncludeAttributeStatement(null));
    }

    @Test
    public void testIndirectIncludeAttributeStatement() {
        BrowserSSOProfileConfiguration config = new BrowserSSOProfileConfiguration();
        config.setIncludeAttributeStatementPredicate((Predicate)Predicates.alwaysFalse());
        Assert.assertFalse((boolean)config.isIncludeAttributeStatement(null));
    }

    @Test
    public void testSkipEndpointValidationWhenSigned() {
        BrowserSSOProfileConfiguration config = new BrowserSSOProfileConfiguration();
        Assert.assertFalse((boolean)config.isSkipEndpointValidationWhenSigned(null));
        config.setSkipEndpointValidationWhenSigned(true);
        Assert.assertTrue((boolean)config.isSkipEndpointValidationWhenSigned(null));
    }

    @Test
    public void testIndirectEndpointValidationWhenSigned() {
        BrowserSSOProfileConfiguration config = new BrowserSSOProfileConfiguration();
        config.setSkipEndpointValidationWhenSignedPredicate((Predicate)Predicates.alwaysTrue());
        Assert.assertTrue((boolean)config.isSkipEndpointValidationWhenSigned(null));
    }

    @Test
    public void testMaximumSPSessionLifeTime() {
        BrowserSSOProfileConfiguration config = new BrowserSSOProfileConfiguration();
        Assert.assertNull((Object)config.getMaximumSPSessionLifetime(null));
        config.setMaximumSPSessionLifetime(Duration.ofSeconds(1L));
        Assert.assertEquals((Object)config.getMaximumSPSessionLifetime(null), (Object)Duration.ofSeconds(1L));
    }

    @Test
    public void testIndirectMaximumSPSessionLifeTime() {
        BrowserSSOProfileConfiguration config = new BrowserSSOProfileConfiguration();
        config.setMaximumSPSessionLifetimeLookupStrategy(FunctionSupport.constant((Object)Duration.ofSeconds(1L)));
        Assert.assertEquals((Object)config.getMaximumSPSessionLifetime(null), (Object)Duration.ofSeconds(1L));
    }

    @Test
    public void testAllowDelegation() {
        BrowserSSOProfileConfiguration config = new BrowserSSOProfileConfiguration();
        Assert.assertFalse((boolean)config.isAllowDelegation(null));
        com.google.common.base.Predicate predicate = Predicates.alwaysTrue();
        config.setAllowDelegationPredicate((Predicate)predicate);
        Assert.assertTrue((boolean)config.isAllowDelegation(null));
        try {
            config.setAllowDelegationPredicate(null);
            Assert.fail((String)"Null predicate should not have been allowed");
        }
        catch (ConstraintViolationException constraintViolationException) {
            // empty catch block
        }
    }

    @Test
    public void testMaximumTokenDelegationChainLength() {
        BrowserSSOProfileConfiguration config = new BrowserSSOProfileConfiguration();
        Assert.assertEquals((long)config.getMaximumTokenDelegationChainLength(null), (long)1L);
        config.setMaximumTokenDelegationChainLength(10L);
        Assert.assertEquals((long)config.getMaximumTokenDelegationChainLength(null), (long)10L);
    }

    @Test
    public void testIndirectMaximumTokenDelegationChainLength() {
        BrowserSSOProfileConfiguration config = new BrowserSSOProfileConfiguration();
        config.setMaximumTokenDelegationChainLengthLookupStrategy(FunctionSupport.constant((Object)10L));
        Assert.assertEquals((long)config.getMaximumTokenDelegationChainLength(null), (long)10L);
    }

    @Test
    public void testArtifactConfiguration() {
        BrowserSSOProfileConfiguration config = new BrowserSSOProfileConfiguration();
        Assert.assertNull((Object)config.getArtifactConfiguration(null));
        BasicSAMLArtifactConfiguration artifactConfiguration = new BasicSAMLArtifactConfiguration();
        config.setArtifactConfiguration((SAMLArtifactConfiguration)artifactConfiguration);
        Assert.assertSame((Object)config.getArtifactConfiguration(null), (Object)artifactConfiguration);
    }

    @Test
    public void testIndirectArtifactConfiguration() {
        BrowserSSOProfileConfiguration config = new BrowserSSOProfileConfiguration();
        BasicSAMLArtifactConfiguration artifactConfiguration = new BasicSAMLArtifactConfiguration();
        config.setArtifactConfigurationLookupStrategy(FunctionSupport.constant((Object)artifactConfiguration));
        Assert.assertSame((Object)config.getArtifactConfiguration(null), (Object)artifactConfiguration);
    }

    @Test
    public void testDefaultAuthenticationMethods() {
        BrowserSSOProfileConfiguration config = new BrowserSSOProfileConfiguration();
        Assert.assertTrue((boolean)config.getDefaultAuthenticationMethods(null).isEmpty());
        ArrayList<AuthnContextClassRefPrincipal> principals = new ArrayList<AuthnContextClassRefPrincipal>();
        principals.add(new AuthnContextClassRefPrincipal("foo"));
        principals.add(new AuthnContextClassRefPrincipal("bar"));
        config.setDefaultAuthenticationMethods(principals);
        Assert.assertEquals((Collection)config.getDefaultAuthenticationMethods(null), principals);
    }

    @Test
    public void testIndirectDefaultAuthenticationMethods() {
        BrowserSSOProfileConfiguration config = new BrowserSSOProfileConfiguration();
        ArrayList<AuthnContextClassRefPrincipal> principals = new ArrayList<AuthnContextClassRefPrincipal>();
        principals.add(new AuthnContextClassRefPrincipal("foo"));
        principals.add(new AuthnContextClassRefPrincipal("bar"));
        config.setDefaultAuthenticationMethodsLookupStrategy(FunctionSupport.constant(principals));
        Assert.assertEquals((Collection)config.getDefaultAuthenticationMethods(null), principals);
    }

    @Test
    public void testAuthenticationFlows() {
        BrowserSSOProfileConfiguration config = new BrowserSSOProfileConfiguration();
        Assert.assertTrue((boolean)config.getAuthenticationFlows(null).isEmpty());
        HashSet<String> flows = new HashSet<String>();
        flows.add("foo");
        flows.add("bar");
        config.setAuthenticationFlows(flows);
        Assert.assertEquals((Set)config.getAuthenticationFlows(null), flows);
    }

    @Test
    public void testIndirectAuthenticationFlows() {
        BrowserSSOProfileConfiguration config = new BrowserSSOProfileConfiguration();
        HashSet<String> flows = new HashSet<String>();
        flows.add("foo");
        flows.add("bar");
        config.setAuthenticationFlowsLookupStrategy(FunctionSupport.constant(flows));
        Assert.assertEquals((Set)config.getAuthenticationFlows(null), flows);
    }

    @Test
    public void testPostAuthenticationFlows() {
        BrowserSSOProfileConfiguration config = new BrowserSSOProfileConfiguration();
        Assert.assertTrue((boolean)config.getPostAuthenticationFlows(null).isEmpty());
        ArrayList<String> flows = new ArrayList<String>();
        flows.add("foo");
        flows.add("bar");
        config.setPostAuthenticationFlows(flows);
        Assert.assertEquals((Collection)config.getPostAuthenticationFlows(null), flows);
    }

    @Test
    public void testIndirectPostAuthenticationFlows() {
        BrowserSSOProfileConfiguration config = new BrowserSSOProfileConfiguration();
        ArrayList<String> flows = new ArrayList<String>();
        flows.add("foo");
        flows.add("bar");
        config.setPostAuthenticationFlowsLookupStrategy(FunctionSupport.constant(flows));
        Assert.assertEquals((Collection)config.getPostAuthenticationFlows(null), flows);
    }

    @Test
    public void testNameIDFormatPrecedence() {
        BrowserSSOProfileConfiguration config = new BrowserSSOProfileConfiguration();
        Assert.assertTrue((boolean)config.getNameIDFormatPrecedence(null).isEmpty());
        ArrayList<String> formats = new ArrayList<String>();
        formats.add("foo");
        formats.add("bar");
        config.setNameIDFormatPrecedence(formats);
        Assert.assertEquals((Collection)config.getNameIDFormatPrecedence(null), formats);
    }

    @Test
    public void testIndirectNameIDFormatPrecedence() {
        BrowserSSOProfileConfiguration config = new BrowserSSOProfileConfiguration();
        ArrayList<String> formats = new ArrayList<String>();
        formats.add("foo");
        formats.add("bar");
        config.setNameIDFormatPrecedenceLookupStrategy(FunctionSupport.constant(formats));
        Assert.assertEquals((Collection)config.getNameIDFormatPrecedence(null), formats);
    }

    @Test
    public void testSignArtifactRequests() {
        BrowserSSOProfileConfiguration config = new BrowserSSOProfileConfiguration();
        config.setSignArtifactRequests(true);
        Assert.assertTrue((boolean)config.isSignArtifactRequests(null));
    }

    @Test
    public void testClientTLSArtifactRequests() {
        BrowserSSOProfileConfiguration config = new BrowserSSOProfileConfiguration();
        config.setClientTLSArtifactRequests(true);
        Assert.assertTrue((boolean)config.isClientTLSArtifactRequests(null));
    }
}

