/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.saml2.profile.config.navigate;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import net.shibboleth.idp.authn.context.AuthenticationContext;
import net.shibboleth.idp.authn.context.RequestedPrincipalContext;
import net.shibboleth.idp.profile.testing.RequestContextBuilder;
import net.shibboleth.idp.saml.authn.principal.AuthenticationMethodPrincipal;
import net.shibboleth.idp.saml.authn.principal.AuthnContextClassRefPrincipal;
import net.shibboleth.idp.saml.authn.principal.AuthnContextDeclRefPrincipal;
import net.shibboleth.idp.saml.saml2.profile.config.navigate.ProxyAwareDefaultAuthenticationMethodsLookupFunction;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import org.opensaml.core.testing.OpenSAMLInitBaseTestCase;
import org.opensaml.profile.context.ProfileRequestContext;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class ProxyAwareDefaultAuthenticationMethodsLookupFunctionTest
extends OpenSAMLInitBaseTestCase {
    private ProfileRequestContext prc1;
    private ProfileRequestContext prc2;
    private AuthenticationContext ac;
    private RequestedPrincipalContext rpc;
    private ProxyAwareDefaultAuthenticationMethodsLookupFunction fn;

    @BeforeMethod
    public void setUp() throws ComponentInitializationException {
        this.prc1 = new RequestContextBuilder().buildProfileRequestContext();
        this.ac = (AuthenticationContext)this.prc1.getSubcontext(AuthenticationContext.class, true);
        this.prc2 = (ProfileRequestContext)this.ac.getSubcontext(ProfileRequestContext.class, true);
        this.rpc = (RequestedPrincipalContext)this.ac.getSubcontext(RequestedPrincipalContext.class, true);
        this.fn = new ProxyAwareDefaultAuthenticationMethodsLookupFunction();
    }

    @Test
    public void testEmptyTree() {
        Collection principals = this.fn.apply(this.prc1);
        Assert.assertTrue((boolean)principals.isEmpty());
    }

    @Test
    public void testNonProxy() {
        this.rpc.setRequestedPrincipals(List.of(new AuthnContextClassRefPrincipal("foo"), new AuthnContextClassRefPrincipal("bar")));
        Collection principals = this.fn.apply(this.prc1);
        Assert.assertTrue((boolean)principals.isEmpty());
    }

    @Test
    public void testPassthrough() {
        this.rpc.setRequestedPrincipals(List.of(new AuthnContextClassRefPrincipal("foo"), new AuthnContextClassRefPrincipal("bar")));
        Collection principals = this.fn.apply(this.prc2);
        Assert.assertEquals((Collection)principals, (Collection)this.rpc.getRequestedPrincipals());
    }

    @Test
    public void testMapped() {
        this.rpc.setRequestedPrincipals(List.of(new AuthnContextClassRefPrincipal("foo"), new AuthnContextClassRefPrincipal("bar"), new AuthenticationMethodPrincipal("baz")));
        HashMap<Object, List<Object>> mappings = new HashMap<Object, List<Object>>();
        mappings.put(new AuthnContextClassRefPrincipal("foo"), Collections.emptyList());
        mappings.put(new AuthenticationMethodPrincipal("baz"), List.of(new AuthnContextClassRefPrincipal("frobnitz"), new AuthnContextDeclRefPrincipal("grue"), new AuthnContextClassRefPrincipal("zorkmid")));
        this.fn.setMappings(mappings);
        Collection principals = this.fn.apply(this.prc2);
        Assert.assertEquals((Collection)principals.stream().map(p -> p.getName()).collect(Collectors.toUnmodifiableList()), List.of("bar", "frobnitz", "zorkmid"));
    }
}

