/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.saml2.profile.config.navigate;

import java.security.Principal;
import java.util.Collections;
import java.util.Set;
import javax.security.auth.Subject;
import net.shibboleth.idp.authn.AuthenticationResult;
import net.shibboleth.idp.authn.context.SubjectContext;
import net.shibboleth.idp.authn.principal.ProxyAuthenticationPrincipal;
import net.shibboleth.idp.profile.config.ProfileConfiguration;
import net.shibboleth.idp.profile.context.RelyingPartyContext;
import net.shibboleth.idp.profile.testing.RequestContextBuilder;
import net.shibboleth.idp.saml.saml2.profile.config.BrowserSSOProfileConfiguration;
import net.shibboleth.idp.saml.saml2.profile.config.navigate.ProxyRestrictionLookupFunction;
import net.shibboleth.utilities.java.support.collection.Pair;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import org.opensaml.core.testing.OpenSAMLInitBaseTestCase;
import org.opensaml.messaging.context.BaseContext;
import org.opensaml.profile.context.ProfileRequestContext;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class ProxyRestrictionLookupFunctionTest
extends OpenSAMLInitBaseTestCase {
    private ProfileRequestContext prc;
    private SubjectContext sc;
    private BrowserSSOProfileConfiguration config;
    private ProxyRestrictionLookupFunction fn;
    private Pair<Integer, Set<String>> result;

    @BeforeMethod
    public void setUp() throws ComponentInitializationException {
        this.prc = new RequestContextBuilder().setRelyingPartyProfileConfigurations(Collections.singletonList(new BrowserSSOProfileConfiguration())).buildProfileRequestContext();
        this.config = (BrowserSSOProfileConfiguration)((RelyingPartyContext)this.prc.getSubcontext(RelyingPartyContext.class)).getConfiguration().getProfileConfiguration(this.prc, "http://shibboleth.net/ns/profiles/saml2/sso/browser");
        ((RelyingPartyContext)this.prc.getSubcontext(RelyingPartyContext.class)).setProfileConfig((ProfileConfiguration)this.config);
        this.sc = (SubjectContext)this.prc.getSubcontext(SubjectContext.class, true);
        this.sc.getAuthenticationResults().put("test1", new AuthenticationResult("test1", new Subject()));
        this.sc.getAuthenticationResults().put("test2", new AuthenticationResult("test2", new Subject()));
        this.fn = new ProxyRestrictionLookupFunction();
    }

    @Test
    public void testNoPrincipals() {
        this.result = this.fn.apply(this.prc);
        Assert.assertNull((Object)this.result.getFirst());
        Assert.assertTrue((boolean)((Set)this.result.getSecond()).isEmpty());
    }

    @Test
    public void testOneEmptyPrincipal() {
        ProxyAuthenticationPrincipal proxy = new ProxyAuthenticationPrincipal();
        ((AuthenticationResult)this.sc.getAuthenticationResults().get("test2")).getSubject().getPrincipals().add((Principal)proxy);
        this.result = this.fn.apply(this.prc);
        Assert.assertNull((Object)this.result.getFirst());
        Assert.assertTrue((boolean)((Set)this.result.getSecond()).isEmpty());
    }

    @Test
    public void testOneCount() {
        ProxyAuthenticationPrincipal proxy = new ProxyAuthenticationPrincipal();
        proxy.setProxyCount(Integer.valueOf(10));
        ((AuthenticationResult)this.sc.getAuthenticationResults().get("test2")).getSubject().getPrincipals().add((Principal)proxy);
        this.result = this.fn.apply(this.prc);
        Assert.assertEquals((Object)this.result.getFirst(), (Object)9);
        Assert.assertTrue((boolean)((Set)this.result.getSecond()).isEmpty());
        proxy.setProxyCount(Integer.valueOf(1));
        this.result = this.fn.apply(this.prc);
        Assert.assertEquals((Object)this.result.getFirst(), (Object)0);
        proxy.setProxyCount(Integer.valueOf(0));
        this.result = this.fn.apply(this.prc);
        Assert.assertEquals((Object)this.result.getFirst(), (Object)0);
    }

    @Test
    public void testTwoCounts() {
        ProxyAuthenticationPrincipal proxy1 = new ProxyAuthenticationPrincipal();
        proxy1.setProxyCount(Integer.valueOf(10));
        ((AuthenticationResult)this.sc.getAuthenticationResults().get("test1")).getSubject().getPrincipals().add((Principal)proxy1);
        ProxyAuthenticationPrincipal proxy2 = new ProxyAuthenticationPrincipal();
        proxy1.setProxyCount(Integer.valueOf(5));
        ((AuthenticationResult)this.sc.getAuthenticationResults().get("test2")).getSubject().getPrincipals().add((Principal)proxy2);
        this.result = this.fn.apply(this.prc);
        Assert.assertEquals((Object)this.result.getFirst(), (Object)4);
        Assert.assertTrue((boolean)((Set)this.result.getSecond()).isEmpty());
        proxy1.setProxyCount(Integer.valueOf(1));
        proxy2.setProxyCount(Integer.valueOf(1));
        this.result = this.fn.apply(this.prc);
        Assert.assertEquals((Object)this.result.getFirst(), (Object)0);
        proxy1.setProxyCount(Integer.valueOf(0));
        proxy1.setProxyCount(Integer.valueOf(5));
        this.result = this.fn.apply(this.prc);
        Assert.assertEquals((Object)this.result.getFirst(), (Object)0);
    }

    @Test
    public void testOneAudienceSet() {
        ProxyAuthenticationPrincipal proxy = new ProxyAuthenticationPrincipal();
        proxy.setProxyCount(Integer.valueOf(10));
        proxy.getAudiences().addAll(Set.of("foo", "bar"));
        ((AuthenticationResult)this.sc.getAuthenticationResults().get("test2")).getSubject().getPrincipals().add((Principal)proxy);
        this.result = this.fn.apply(this.prc);
        Assert.assertEquals((Object)this.result.getFirst(), (Object)9);
        Assert.assertEquals((Set)((Set)this.result.getSecond()), Set.of("foo", "bar"));
    }

    @Test
    public void testTwoAudienceSets() {
        ProxyAuthenticationPrincipal proxy1 = new ProxyAuthenticationPrincipal();
        proxy1.setProxyCount(Integer.valueOf(10));
        proxy1.getAudiences().addAll(Set.of("foo", "bar"));
        ((AuthenticationResult)this.sc.getAuthenticationResults().get("test1")).getSubject().getPrincipals().add((Principal)proxy1);
        ProxyAuthenticationPrincipal proxy2 = new ProxyAuthenticationPrincipal();
        proxy2.getAudiences().addAll(Set.of("foo", "bar"));
        ((AuthenticationResult)this.sc.getAuthenticationResults().get("test2")).getSubject().getPrincipals().add((Principal)proxy2);
        this.result = this.fn.apply(this.prc);
        Assert.assertEquals((Object)this.result.getFirst(), (Object)9);
        Assert.assertEquals((Set)((Set)this.result.getSecond()), Set.of("foo", "bar"));
        proxy1.getAudiences().clear();
        proxy1.getAudiences().add("bar");
        this.result = this.fn.apply(this.prc);
        Assert.assertEquals((Set)((Set)this.result.getSecond()), Set.of("bar"));
        proxy2.getAudiences().clear();
        proxy2.getAudiences().add("foo");
        this.result = this.fn.apply(this.prc);
        Assert.assertTrue((boolean)((Set)this.result.getSecond()).isEmpty());
    }

    @Test
    public void testConfigOnly() {
        this.config.setProxyCount(Integer.valueOf(5));
        this.config.setProxyAudiences(Set.of("foo", "bar"));
        this.prc.removeSubcontext((BaseContext)this.sc);
        this.result = this.fn.apply(this.prc);
        Assert.assertEquals((Object)this.result.getFirst(), (Object)5);
        Assert.assertEquals((Set)((Set)this.result.getSecond()), Set.of("foo", "bar"));
    }

    @Test
    public void testJointCount() {
        this.config.setProxyCount(Integer.valueOf(5));
        ProxyAuthenticationPrincipal proxy1 = new ProxyAuthenticationPrincipal();
        proxy1.setProxyCount(Integer.valueOf(10));
        ((AuthenticationResult)this.sc.getAuthenticationResults().get("test1")).getSubject().getPrincipals().add((Principal)proxy1);
        ProxyAuthenticationPrincipal proxy2 = new ProxyAuthenticationPrincipal();
        proxy1.setProxyCount(Integer.valueOf(5));
        ((AuthenticationResult)this.sc.getAuthenticationResults().get("test2")).getSubject().getPrincipals().add((Principal)proxy2);
        this.result = this.fn.apply(this.prc);
        Assert.assertEquals((Object)this.result.getFirst(), (Object)4);
        Assert.assertTrue((boolean)((Set)this.result.getSecond()).isEmpty());
        this.config.setProxyCount(Integer.valueOf(1));
        proxy1.setProxyCount(Integer.valueOf(1));
        this.result = this.fn.apply(this.prc);
        Assert.assertEquals((Object)this.result.getFirst(), (Object)0);
        this.config.setProxyCount(Integer.valueOf(0));
        proxy1.setProxyCount(Integer.valueOf(3));
        this.result = this.fn.apply(this.prc);
        Assert.assertEquals((Object)this.result.getFirst(), (Object)0);
    }

    @Test
    public void testJointAudiences() {
        this.config.setProxyAudiences(Set.of("foo", "bar"));
        ProxyAuthenticationPrincipal proxy1 = new ProxyAuthenticationPrincipal();
        proxy1.getAudiences().addAll(Set.of("foo", "bar"));
        ((AuthenticationResult)this.sc.getAuthenticationResults().get("test1")).getSubject().getPrincipals().add((Principal)proxy1);
        ProxyAuthenticationPrincipal proxy2 = new ProxyAuthenticationPrincipal();
        proxy2.getAudiences().addAll(Set.of("foo", "bar"));
        ((AuthenticationResult)this.sc.getAuthenticationResults().get("test2")).getSubject().getPrincipals().add((Principal)proxy2);
        this.result = this.fn.apply(this.prc);
        Assert.assertNull((Object)this.result.getFirst());
        Assert.assertEquals((Set)((Set)this.result.getSecond()), Set.of("foo", "bar"));
        this.config.setProxyAudiences(Set.of("foo", "baz"));
        this.result = this.fn.apply(this.prc);
        Assert.assertEquals((Set)((Set)this.result.getSecond()), Set.of("foo"));
        proxy2.getAudiences().clear();
        proxy2.getAudiences().addAll(Set.of("foo", "bar", "baz"));
        this.result = this.fn.apply(this.prc);
        Assert.assertEquals((Set)((Set)this.result.getSecond()), Set.of("foo"));
        proxy1.getAudiences().clear();
        proxy1.getAudiences().add("bar");
        this.result = this.fn.apply(this.prc);
        Assert.assertTrue((boolean)((Set)this.result.getSecond()).isEmpty());
        Assert.assertEquals((Object)this.result.getFirst(), (Object)0);
    }
}

