/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.session;

import java.time.Instant;
import javax.xml.namespace.QName;
import net.shibboleth.idp.saml.session.SAML2SPSession;
import net.shibboleth.utilities.java.support.logic.ConstraintViolationException;
import org.opensaml.core.testing.OpenSAMLInitBaseTestCase;
import org.opensaml.core.xml.util.XMLObjectSupport;
import org.opensaml.saml.saml2.core.NameID;
import org.testng.Assert;
import org.testng.annotations.Test;

public class SAML2SPSessionTest
extends OpenSAMLInitBaseTestCase {
    @Test
    public void testInstantiation() throws Exception {
        NameID nameID = (NameID)XMLObjectSupport.buildXMLObject((QName)NameID.DEFAULT_ELEMENT_NAME);
        nameID.setValue("joe@example.org");
        nameID.setFormat("urn:oasis:names:tc:SAML:1.1:nameid-format:emailAddress");
        Instant start = Instant.now();
        Thread.sleep(50L);
        SAML2SPSession session = new SAML2SPSession("test", Instant.now(), Instant.now().plusSeconds(60L), nameID, "1234567890", "https://sp.example.org/acs", false);
        Assert.assertEquals((String)session.getId(), (String)"test");
        Assert.assertTrue((boolean)session.getCreationInstant().isAfter(start));
        Assert.assertTrue((boolean)session.getExpirationInstant().isAfter(session.getCreationInstant()));
        Assert.assertSame((Object)session.getNameID(), (Object)nameID);
        Assert.assertEquals((String)session.getSessionIndex(), (String)"1234567890");
        Assert.assertEquals((String)session.getSPSessionKey(), (String)"joe@example.org");
        Assert.assertEquals((String)session.getACSLocation(), (String)"https://sp.example.org/acs");
        Assert.assertFalse((boolean)session.supportsLogoutPropagation());
        try {
            new SAML2SPSession(null, Instant.ofEpochMilli(0L), Instant.ofEpochMilli(0L), null, null, null, true);
            Assert.fail();
        }
        catch (ConstraintViolationException constraintViolationException) {
            // empty catch block
        }
        try {
            new SAML2SPSession("", Instant.ofEpochMilli(0L), Instant.ofEpochMilli(0L), null, null, null, true);
            Assert.fail();
        }
        catch (ConstraintViolationException constraintViolationException) {
            // empty catch block
        }
        try {
            new SAML2SPSession("  ", Instant.ofEpochMilli(0L), Instant.ofEpochMilli(0L), null, null, null, true);
            Assert.fail();
        }
        catch (ConstraintViolationException constraintViolationException) {
            // empty catch block
        }
        try {
            new SAML2SPSession("foo", Instant.ofEpochMilli(0L), Instant.ofEpochMilli(0L), null, null, null, true);
            Assert.fail();
        }
        catch (ConstraintViolationException constraintViolationException) {
            // empty catch block
        }
        try {
            new SAML2SPSession("foo", start, Instant.ofEpochMilli(0L), null, null, null, true);
            Assert.fail();
        }
        catch (ConstraintViolationException constraintViolationException) {
            // empty catch block
        }
        try {
            new SAML2SPSession("foo", start, start, null, null, null, true);
            Assert.fail();
        }
        catch (ConstraintViolationException constraintViolationException) {
            // empty catch block
        }
        try {
            new SAML2SPSession("foo", start, start, nameID, null, null, true);
            Assert.fail();
        }
        catch (ConstraintViolationException constraintViolationException) {
            // empty catch block
        }
    }
}

