/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.saml2.profile.config.navigate;

import java.security.Principal;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.authn.context.AuthenticationContext;
import net.shibboleth.idp.authn.context.RequestedPrincipalContext;
import net.shibboleth.shared.annotation.constraint.NotLive;
import net.shibboleth.shared.annotation.constraint.Unmodifiable;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.primitive.NonnullSupplier;
import org.opensaml.messaging.context.BaseContext;
import org.opensaml.profile.context.ProfileRequestContext;

public class ProxyAwareDefaultAuthenticationMethodsLookupFunction
implements Function<ProfileRequestContext, Collection<Principal>> {
    @Nonnull
    private Map<Principal, Collection<Principal>> principalMappings = CollectionSupport.emptyMap();

    public void setMappings(@Nullable Map<Principal, Collection<Principal>> mappings) {
        if (mappings == null || mappings.isEmpty()) {
            this.principalMappings = CollectionSupport.emptyMap();
            return;
        }
        this.principalMappings = new HashMap<Principal, Collection<Principal>>(mappings.size());
        mappings.forEach((k, v) -> this.principalMappings.put((Principal)k, List.copyOf(v)));
    }

    @Override
    @Nonnull
    @Unmodifiable
    @NotLive
    public Collection<Principal> apply(@Nullable ProfileRequestContext input) {
        RequestedPrincipalContext rpc;
        BaseContext parent;
        if (input != null && (parent = input.getParent()) instanceof AuthenticationContext && (rpc = (RequestedPrincipalContext)parent.getSubcontext(RequestedPrincipalContext.class)) != null) {
            return (Collection)((NonnullSupplier)rpc.getRequestedPrincipals().stream().map(p -> {
                if (this.principalMappings.containsKey(p)) {
                    return this.principalMappings.get(p);
                }
                return CollectionSupport.singletonList((Object)p);
            }).flatMap(Collection::stream).collect(CollectionSupport.nonnullCollector(Collectors.toUnmodifiableList()))).get();
        }
        return CollectionSupport.emptyList();
    }
}

