/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.saml2.profile.config.navigate;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.authn.context.SubjectContext;
import net.shibboleth.idp.authn.principal.ProxyAuthenticationPrincipal;
import net.shibboleth.idp.saml.saml2.profile.config.BrowserSSOProfileConfiguration;
import net.shibboleth.profile.config.ProfileConfiguration;
import net.shibboleth.profile.context.RelyingPartyContext;
import net.shibboleth.profile.context.navigate.AbstractRelyingPartyLookupFunction;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.collection.Pair;
import net.shibboleth.shared.logic.Constraint;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.profile.context.ProfileRequestContext;

public class ProxyRestrictionLookupFunction
extends AbstractRelyingPartyLookupFunction<Pair<Integer, Set<String>>> {
    @Nonnull
    private Function<ProfileRequestContext, SubjectContext> subjectContextLookupStrategy = new ChildContextLookup(SubjectContext.class);

    public void setSubjectContextLookupStrategy(@Nonnull Function<ProfileRequestContext, SubjectContext> strategy) {
        this.subjectContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"SubjectContext lookup strategy cannot be null");
    }

    @Nonnull
    public Pair<Integer, Set<String>> apply(@Nullable ProfileRequestContext input) {
        SubjectContext sc;
        Set proxieds;
        ProfileConfiguration pc;
        Integer proxyCount = null;
        HashSet<String> audiences = new HashSet<String>();
        RelyingPartyContext rpc = (RelyingPartyContext)this.getRelyingPartyContextLookupStrategy().apply(input);
        if (rpc != null && (pc = rpc.getProfileConfig()) instanceof BrowserSSOProfileConfiguration) {
            BrowserSSOProfileConfiguration sso = (BrowserSSOProfileConfiguration)pc;
            proxyCount = sso.getProxyCount(input);
            Set<String> configAudiences = sso.getProxyAudiences(input);
            if (configAudiences != null && !configAudiences.isEmpty()) {
                audiences.addAll(configAudiences);
            }
        }
        Set set = proxieds = (sc = this.subjectContextLookupStrategy.apply(input)) == null ? CollectionSupport.emptySet() : sc.getSubjects().stream().map(s -> s.getPrincipals(ProxyAuthenticationPrincipal.class)).flatMap(Collection::stream).collect(Collectors.toUnmodifiableSet());
        if (proxieds.isEmpty()) {
            return new Pair((Object)proxyCount, Set.copyOf(audiences));
        }
        for (ProxyAuthenticationPrincipal p : proxieds) {
            Integer upstreamCount;
            Set upstreamAudiences = p.getAudiences();
            if (upstreamAudiences != null && !upstreamAudiences.isEmpty()) {
                if (audiences.isEmpty()) {
                    audiences.addAll(upstreamAudiences);
                } else {
                    audiences.retainAll(upstreamAudiences);
                    if (audiences.isEmpty()) {
                        return new Pair((Object)0, (Object)CollectionSupport.emptySet());
                    }
                }
            }
            if ((upstreamCount = p.getProxyCount()) == null) continue;
            if (proxyCount != null) {
                proxyCount = Integer.min(proxyCount, Integer.max(0, upstreamCount - 1));
                continue;
            }
            proxyCount = Integer.max(0, upstreamCount - 1);
        }
        return new Pair((Object)proxyCount, (Object)CollectionSupport.copyToSet(audiences));
    }
}

