/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.attribute.encoding.impl;

import com.google.common.base.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.attribute.AttributeEncodingException;
import net.shibboleth.idp.attribute.IdPAttribute;
import net.shibboleth.idp.attribute.IdPAttributeValue;
import net.shibboleth.idp.saml.attribute.encoding.AbstractSAML1NameIdentifierEncoder;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.ConstraintViolationException;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import org.opensaml.core.xml.config.XMLObjectProviderRegistrySupport;
import org.opensaml.saml.common.SAMLObjectBuilder;
import org.opensaml.saml.saml1.core.NameIdentifier;
import org.opensaml.saml.saml1.profile.SAML1ObjectSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SAML1StringNameIdentifierEncoder
extends AbstractSAML1NameIdentifierEncoder {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(SAML1StringNameIdentifierEncoder.class);
    @Nonnull
    private final SAMLObjectBuilder<NameIdentifier> identifierBuilder = (SAMLObjectBuilder)XMLObjectProviderRegistrySupport.getBuilderFactory().getBuilder(NameIdentifier.DEFAULT_ELEMENT_NAME);
    @Nullable
    private String format;
    @Nullable
    private String qualifier;

    public SAML1StringNameIdentifierEncoder() {
        if (this.identifierBuilder == null) {
            throw new ConstraintViolationException("Builder unavailable for NameIdentifier objects");
        }
    }

    @Nullable
    public final String getNameFormat() {
        return this.format;
    }

    public final void setNameFormat(@Nullable String nameFormat) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.format = StringSupport.trimOrNull((String)nameFormat);
    }

    @Nullable
    public final String getNameQualifier() {
        return this.qualifier;
    }

    @Nullable
    public final void setNameQualifier(String nameQualifier) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.qualifier = StringSupport.trimOrNull((String)nameQualifier);
    }

    public boolean apply(@Nullable String input) {
        return SAML1ObjectSupport.areNameIdentifierFormatsEquivalent((String)input, (String)this.format);
    }

    @Nonnull
    public NameIdentifier encode(@Nonnull IdPAttribute attribute) throws AttributeEncodingException {
        String attributeId = attribute.getId();
        Set attributeValues = attribute.getValues();
        if (attributeValues == null || attributeValues.isEmpty()) {
            throw new AttributeEncodingException("Attribute " + attribute.getId() + " does not contain any values to encode");
        }
        NameIdentifier nameId = (NameIdentifier)this.identifierBuilder.buildObject();
        nameId.setFormat(this.format);
        nameId.setNameQualifier(this.qualifier);
        for (IdPAttributeValue attrValue : attributeValues) {
            if (attrValue == null || attrValue.getValue() == null) {
                this.log.debug("Skipping null value of attribute {}", (Object)attributeId);
                continue;
            }
            Object value = attrValue.getValue();
            if (value instanceof String) {
                nameId.setNameIdentifier((String)value);
                return nameId;
            }
            this.log.debug("Skipping unsupported value of type {} of attribute {}", (Object)value.getClass().getName(), (Object)attributeId);
        }
        throw new AttributeEncodingException("Attribute '" + attributeId + "' did not contain any encodable values");
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof SAML1StringNameIdentifierEncoder)) {
            return false;
        }
        SAML1StringNameIdentifierEncoder other = (SAML1StringNameIdentifierEncoder)((Object)obj);
        return Objects.equal((Object)this.getNameFormat(), (Object)other.getNameFormat()) && Objects.equal((Object)this.getNameQualifier(), (Object)other.getNameQualifier());
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.getNameFormat(), this.getNameQualifier(), this.getProtocol(), SAML1StringNameIdentifierEncoder.class});
    }
}

