/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.attribute.encoding.impl;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.namespace.QName;
import net.shibboleth.idp.attribute.AttributeEncodingException;
import net.shibboleth.idp.attribute.IdPAttribute;
import net.shibboleth.idp.attribute.IdPAttributeValue;
import net.shibboleth.idp.attribute.IdPRequestedAttribute;
import net.shibboleth.idp.attribute.ScopedStringAttributeValue;
import net.shibboleth.idp.saml.attribute.encoding.AbstractSAML2AttributeEncoder;
import net.shibboleth.idp.saml.attribute.encoding.AttributeMapperProcessor;
import net.shibboleth.idp.saml.attribute.encoding.SAMLEncoderSupport;
import net.shibboleth.idp.saml.attribute.mapping.AbstractSAMLAttributeMapper;
import net.shibboleth.idp.saml.attribute.mapping.AbstractSAMLAttributeValueMapper;
import net.shibboleth.idp.saml.attribute.mapping.impl.ScopedStringAttributeValueMapper;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.saml.saml2.core.AttributeValue;
import org.opensaml.saml.saml2.metadata.RequestedAttribute;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SAML2ScopedStringAttributeEncoder
extends AbstractSAML2AttributeEncoder<ScopedStringAttributeValue>
implements AttributeMapperProcessor<RequestedAttribute, IdPRequestedAttribute> {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(SAML2ScopedStringAttributeEncoder.class);
    @Nullable
    private String scopeType;
    @Nullable
    private String scopeDelimiter;
    @Nullable
    private String scopeAttributeName;

    @Nullable
    public String getScopeAttributeName() {
        return this.scopeAttributeName;
    }

    @Nullable
    public String getScopeDelimiter() {
        return this.scopeDelimiter;
    }

    @Nullable
    public String getScopeType() {
        return this.scopeType;
    }

    public void setScopeAttributeName(@Nullable String newScopeAttribute) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.scopeAttributeName = StringSupport.trimOrNull((String)newScopeAttribute);
    }

    public void setScopeDelimiter(@Nullable String newScopeDelimiter) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.scopeDelimiter = StringSupport.trimOrNull((String)newScopeDelimiter);
    }

    public void setScopeType(@Nullable String newScopeType) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.scopeType = StringSupport.trimOrNull((String)newScopeType);
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (null == this.getScopeType()) {
            this.log.debug("Scope type not set, assuming \"inline\"");
            this.scopeType = "inline";
        }
        if ("attribute".equals(this.getScopeType())) {
            if (null == this.getScopeAttributeName()) {
                throw new ComponentInitializationException("Encoder of type \"attribute\" must specify a scope attribute name");
            }
            if (null != this.getScopeDelimiter()) {
                this.log.warn("Scope delimiter {} not valid for type \"attribute\"", (Object)this.getScopeDelimiter());
            }
        } else if ("inline".equals(this.getScopeType())) {
            if (null == this.getScopeDelimiter()) {
                throw new ComponentInitializationException("Encoder of type \"inline\" must specify a scope delimiter");
            }
            if (null != this.getScopeAttributeName()) {
                this.log.warn("Scope attribute name {} not valid for type \"inline\"", (Object)this.getScopeAttributeName());
            }
        } else {
            throw new ComponentInitializationException("Encoder scope type must be set to \"inline\" or \"attribute\"");
        }
    }

    protected boolean canEncodeValue(@Nonnull IdPAttribute attribute, @Nonnull IdPAttributeValue value) {
        ComponentSupport.ifNotInitializedThrowUninitializedComponentException((InitializableComponent)this);
        return value instanceof ScopedStringAttributeValue;
    }

    @Nullable
    protected XMLObject encodeValue(@Nonnull IdPAttribute attribute, @Nonnull ScopedStringAttributeValue value) throws AttributeEncodingException {
        ComponentSupport.ifNotInitializedThrowUninitializedComponentException((InitializableComponent)this);
        if ("attribute".equals(this.getScopeType())) {
            return SAMLEncoderSupport.encodeScopedStringValueAttribute((IdPAttribute)attribute, (QName)AttributeValue.DEFAULT_ELEMENT_NAME, (ScopedStringAttributeValue)value, (String)this.getScopeAttributeName());
        }
        return SAMLEncoderSupport.encodeScopedStringValueInline((IdPAttribute)attribute, (QName)AttributeValue.DEFAULT_ELEMENT_NAME, (ScopedStringAttributeValue)value, (String)this.getScopeDelimiter());
    }

    @Nonnull
    public void populateAttributeMapper(AbstractSAMLAttributeMapper<RequestedAttribute, IdPRequestedAttribute> mapper) {
        mapper.setAttributeFormat(this.getNameFormat());
        mapper.setId(this.getFriendlyName());
        mapper.setSAMLName(this.getName());
        ScopedStringAttributeValueMapper foo = new ScopedStringAttributeValueMapper();
        foo.setDelimiter(this.getScopeDelimiter());
        mapper.setValueMapper((AbstractSAMLAttributeValueMapper)foo);
    }
}

