/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.attribute.principalconnector.impl;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.attribute.resolver.LegacyPrincipalDecoder;
import net.shibboleth.idp.attribute.resolver.ResolutionException;
import net.shibboleth.idp.authn.context.SubjectCanonicalizationContext;
import net.shibboleth.idp.saml.attribute.principalconnector.impl.PrincipalConnector;
import net.shibboleth.idp.saml.authn.principal.NameIDPrincipal;
import net.shibboleth.idp.saml.authn.principal.NameIdentifierPrincipal;
import net.shibboleth.idp.saml.nameid.NameDecoderException;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.annotation.constraint.NullableElements;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.opensaml.saml.saml1.core.NameIdentifier;
import org.opensaml.saml.saml1.profile.SAML1ObjectSupport;
import org.opensaml.saml.saml2.core.NameID;
import org.opensaml.saml.saml2.profile.SAML2ObjectSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrinicpalConnectorCanonicalizer
implements LegacyPrincipalDecoder {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(PrinicpalConnectorCanonicalizer.class);
    @Nonnull
    @NonnullElements
    private final Collection<PrincipalConnector> principalConnectors;

    public PrinicpalConnectorCanonicalizer(@Nullable @NullableElements Collection<PrincipalConnector> connectors) {
        this.principalConnectors = null != connectors ? ImmutableSet.copyOf((Iterable)Iterables.filter(connectors, (Predicate)Predicates.notNull())) : Collections.emptySet();
    }

    public boolean hasValidConnectors() {
        return !this.principalConnectors.isEmpty();
    }

    @Nullable
    public String canonicalize(@Nonnull SubjectCanonicalizationContext c14nContext) throws ResolutionException {
        Set<NameIDPrincipal> nameIDPrincipals;
        Constraint.isNotNull((Object)c14nContext, (String)"Context cannot be null");
        if (c14nContext.getSubject() == null) {
            return null;
        }
        Set<NameIdentifierPrincipal> nameIdentifierPrincipals = c14nContext.getSubject().getPrincipals(NameIdentifierPrincipal.class);
        if (nameIdentifierPrincipals != null && !nameIdentifierPrincipals.isEmpty()) {
            if (nameIdentifierPrincipals.size() > 1) {
                this.log.debug("Legacy Principal Decoder: too many NameIdentifierPrincipals");
            } else {
                return this.canonicalize(nameIdentifierPrincipals.iterator().next().getNameIdentifier(), c14nContext);
            }
        }
        if ((nameIDPrincipals = c14nContext.getSubject().getPrincipals(NameIDPrincipal.class)) != null && !nameIDPrincipals.isEmpty()) {
            if (nameIDPrincipals.size() > 1) {
                this.log.debug("Legacy Principal Decoder: too many NameIDPrincipals");
            } else {
                return this.canonicalize(nameIDPrincipals.iterator().next().getNameID(), c14nContext);
            }
        }
        return null;
    }

    @Nullable
    protected String canonicalize(@Nonnull NameIdentifier nameIdentifier, @Nonnull SubjectCanonicalizationContext c14nContext) throws ResolutionException {
        for (PrincipalConnector connector : this.principalConnectors) {
            this.log.trace("Legacy Principal Decoder: looking at connector {}", (Object)connector.getId());
            if (connector.requesterMatches(c14nContext.getRequesterId()) && SAML1ObjectSupport.areNameIdentifierFormatsEquivalent((String)connector.getFormat(), (String)nameIdentifier.getFormat())) {
                try {
                    String result = connector.decode(c14nContext, nameIdentifier);
                    if (null != result) {
                        this.log.trace("Legacy Principal Decoder: decoded to {}", (Object)result);
                        return result;
                    }
                    this.log.trace("Legacy Principal Decoder: decode provided no result");
                    continue;
                }
                catch (NameDecoderException e) {
                    throw new ResolutionException((Exception)((Object)e));
                }
            }
            this.log.trace("Legacy Principal Decoder: format or relying party mismatch");
        }
        return null;
    }

    @Nullable
    protected String canonicalize(@Nonnull NameID nameID, @Nonnull SubjectCanonicalizationContext c14nContext) throws ResolutionException {
        for (PrincipalConnector connector : this.principalConnectors) {
            this.log.trace("Legacy Principal Decoder: looking at connector {}", (Object)connector.getId());
            if (connector.requesterMatches(c14nContext.getRequesterId()) && SAML2ObjectSupport.areNameIdentifierFormatsEquivalent((String)connector.getFormat(), (String)nameID.getFormat())) {
                try {
                    String result = connector.decode(c14nContext, nameID);
                    if (null != result) {
                        this.log.trace("Legacy Principal Decoder: decoded to {}", (Object)result);
                        return result;
                    }
                    this.log.trace("Legacy Principal Decoder: decode provided no result");
                    continue;
                }
                catch (NameDecoderException e) {
                    throw new ResolutionException((Exception)((Object)e));
                }
            }
            this.log.trace("Legacy Principal Decoder: format or relying party mismatch");
        }
        return null;
    }
}

