/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.attribute.resolver.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.attribute.IdPAttribute;
import net.shibboleth.idp.attribute.IdPAttributeValue;
import net.shibboleth.idp.attribute.StringAttributeValue;
import net.shibboleth.idp.attribute.resolver.AbstractDataConnector;
import net.shibboleth.idp.attribute.resolver.PluginDependencySupport;
import net.shibboleth.idp.attribute.resolver.ResolverPluginDependency;
import net.shibboleth.idp.attribute.resolver.context.AttributeResolverWorkContext;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullAfterInit;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.DestructableComponent;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractPersistentIdDataConnector
extends AbstractDataConnector {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(AbstractPersistentIdDataConnector.class);
    @NonnullAfterInit
    private String generatedAttribute;
    @NonnullAfterInit
    private String sourceAttribute;

    @NonnullAfterInit
    public String getSourceAttributeId() {
        return this.sourceAttribute;
    }

    public void setSourceAttributeId(@Nullable String newAttributeId) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.sourceAttribute = StringSupport.trimOrNull((String)newAttributeId);
    }

    @NonnullAfterInit
    public String getGeneratedAttributeId() {
        return this.generatedAttribute;
    }

    public void setGeneratedAttributeId(@Nullable String newAttributeId) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.generatedAttribute = newAttributeId;
    }

    protected void doInitialize() throws ComponentInitializationException {
        if (null == this.getSourceAttributeId()) {
            throw new ComponentInitializationException(this.getLogPrefix() + " No source attribute present.");
        }
        if (null != this.getSourceAttributeId()) {
            for (ResolverPluginDependency depends : this.getDependencies()) {
                depends.setDependencyAttributeId(this.getSourceAttributeId());
            }
        }
        super.doInitialize();
        if (null == this.generatedAttribute) {
            this.generatedAttribute = this.getId();
            this.log.info("{} No generated attribute ID supplied, using ID of connector: {}", (Object)this.getLogPrefix(), (Object)this.generatedAttribute);
        }
    }

    @Nullable
    protected String resolveSourceAttribute(@Nonnull AttributeResolverWorkContext workContext) {
        IdPAttributeValue attributeValue;
        ComponentSupport.ifNotInitializedThrowUninitializedComponentException((InitializableComponent)this);
        ComponentSupport.ifNotInitializedThrowUninitializedComponentException((InitializableComponent)this);
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        Set attributeValues = PluginDependencySupport.getMergedAttributeValues((AttributeResolverWorkContext)workContext, (Collection)this.getDependencies());
        if (attributeValues == null || attributeValues.isEmpty()) {
            this.log.debug("{} Source attribute {} for connector {} provide no values", new Object[]{this.getLogPrefix(), this.getSourceAttributeId(), this.getId()});
            return null;
        }
        if (attributeValues.size() > 1) {
            this.log.warn("{} Source attribute {} for connector {} has more than one value, only one value is used", new Object[]{this.getLogPrefix(), this.getSourceAttributeId(), this.getId()});
        }
        if (!((attributeValue = (IdPAttributeValue)attributeValues.iterator().next()) instanceof StringAttributeValue)) {
            this.log.warn("{} Source attribute {} for connector {} was not a string type.  Not used", new Object[]{this.getLogPrefix(), this.getSourceAttributeId(), this.getId()});
            return null;
        }
        String val = StringSupport.trimOrNull((String)((StringAttributeValue)attributeValue).getValue());
        if (val == null) {
            this.log.warn("{} Attribute {} for connector resolved as empty or null.  Not used", new Object[]{this.getLogPrefix(), this.getSourceAttributeId(), this.getId()});
        }
        return val;
    }

    @Nullable
    protected Map<String, IdPAttribute> encodeAsAttribute(@Nullable String value) {
        ComponentSupport.ifNotInitializedThrowUninitializedComponentException((InitializableComponent)this);
        if (null == value) {
            return null;
        }
        IdPAttribute attribute = new IdPAttribute(this.getGeneratedAttributeId());
        attribute.setValues(Collections.singleton(new StringAttributeValue(value)));
        return Collections.singletonMap(this.getGeneratedAttributeId(), attribute);
    }
}

