/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.attribute.resolver.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.attribute.IdPAttribute;
import net.shibboleth.idp.attribute.IdPAttributeValue;
import net.shibboleth.idp.attribute.StringAttributeValue;
import net.shibboleth.idp.attribute.XMLObjectAttributeValue;
import net.shibboleth.idp.attribute.resolver.AbstractAttributeDefinition;
import net.shibboleth.idp.attribute.resolver.PluginDependencySupport;
import net.shibboleth.idp.attribute.resolver.ResolutionException;
import net.shibboleth.idp.attribute.resolver.context.AttributeResolutionContext;
import net.shibboleth.idp.attribute.resolver.context.AttributeResolverWorkContext;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.DestructableComponent;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.config.XMLObjectProviderRegistrySupport;
import org.opensaml.saml.common.SAMLObjectBuilder;
import org.opensaml.saml.saml2.core.NameID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SAML2NameIDAttributeDefinition
extends AbstractAttributeDefinition {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(SAML2NameIDAttributeDefinition.class);
    @Nonnull
    private final SAMLObjectBuilder<NameID> nameIDBuilder = (SAMLObjectBuilder)XMLObjectProviderRegistrySupport.getBuilderFactory().getBuilderOrThrow(NameID.DEFAULT_ELEMENT_NAME);
    private String nameIdFormat;
    private String nameIdQualifier;
    private String nameIdSPQualifier;

    @Nullable
    public String getNameIdFormat() {
        return this.nameIdFormat;
    }

    public void setNameIdFormat(@Nullable String format) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.nameIdFormat = format;
    }

    @Nullable
    public String getNameIdQualifier() {
        return this.nameIdQualifier;
    }

    public void setNameIdQualifier(@Nullable String qualifier) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.nameIdQualifier = qualifier;
    }

    @Nullable
    public String getNameIdSPQualifier() {
        return this.nameIdSPQualifier;
    }

    public void setNameIdSPQualifier(@Nullable String qualifier) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.nameIdSPQualifier = qualifier;
    }

    protected NameID buildNameId(@Nonnull String nameIdValue, @Nonnull AttributeResolutionContext resolutionContext) throws ResolutionException {
        this.log.debug("{} building a SAML2 NameID with value of '{}'", (Object)this.getLogPrefix(), (Object)nameIdValue);
        String attributeRecipientID = StringSupport.trimOrNull((String)resolutionContext.getAttributeRecipientID());
        String attributeIssuerID = StringSupport.trimOrNull((String)resolutionContext.getAttributeIssuerID());
        NameID nameId = (NameID)this.nameIDBuilder.buildObject();
        nameId.setValue(nameIdValue);
        if (this.nameIdFormat != null) {
            this.log.debug("{} Format set to '{}'", (Object)this.getLogPrefix(), (Object)this.nameIdFormat);
            nameId.setFormat(this.nameIdFormat);
        }
        if (this.nameIdQualifier != null) {
            this.log.debug("{} NameQualifier set to '{}'", (Object)this.getLogPrefix(), (Object)this.nameIdQualifier);
            nameId.setNameQualifier(this.nameIdQualifier);
        } else if (null != attributeIssuerID) {
            this.log.debug("{} NameQualifier set to '{}'", (Object)this.getLogPrefix(), (Object)attributeIssuerID);
            nameId.setNameQualifier(attributeIssuerID);
        } else {
            throw new ResolutionException(this.getLogPrefix() + " provided attribute issuer ID  was empty");
        }
        if (this.nameIdSPQualifier != null) {
            this.log.debug("{} SPNameQualifier set to '{}'", (Object)this.getLogPrefix(), (Object)this.nameIdSPQualifier);
            nameId.setSPNameQualifier(this.nameIdSPQualifier);
        } else if (null != attributeRecipientID) {
            this.log.debug("{} SPNameQualifier set to '{}'", (Object)this.getLogPrefix(), (Object)attributeRecipientID);
            nameId.setSPNameQualifier(attributeRecipientID);
        } else {
            throw new ResolutionException(this.getLogPrefix() + " provided attribute recipient ID was empty");
        }
        return nameId;
    }

    @Nullable
    private XMLObjectAttributeValue encodeOneValue(@Nonnull IdPAttributeValue theValue, @Nonnull AttributeResolutionContext resolutionContext) throws ResolutionException {
        if (theValue instanceof StringAttributeValue) {
            StringAttributeValue value = (StringAttributeValue)theValue;
            NameID nid = this.buildNameId(value.getValue(), resolutionContext);
            XMLObjectAttributeValue val = new XMLObjectAttributeValue((XMLObject)nid);
            return val;
        }
        this.log.warn("{} value {} is not a string", (Object)this.getLogPrefix(), (Object)theValue.toString());
        return null;
    }

    @Nullable
    protected IdPAttribute doAttributeDefinitionResolve(@Nonnull AttributeResolutionContext resolutionContext, @Nonnull AttributeResolverWorkContext workContext) throws ResolutionException {
        ComponentSupport.ifNotInitializedThrowUninitializedComponentException((InitializableComponent)this);
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        Set<XMLObjectAttributeValue> outputValues = null;
        IdPAttribute result = new IdPAttribute(this.getId());
        Set inputValues = PluginDependencySupport.getMergedAttributeValues((AttributeResolverWorkContext)workContext, (Collection)this.getDependencies());
        if (null != inputValues && !inputValues.isEmpty()) {
            if (1 == inputValues.size()) {
                XMLObjectAttributeValue val = this.encodeOneValue((IdPAttributeValue)inputValues.iterator().next(), resolutionContext);
                if (null != val) {
                    outputValues = Collections.singleton(val);
                }
            } else {
                HashSet<XMLObjectAttributeValue> xmlVals = new HashSet<XMLObjectAttributeValue>(inputValues.size());
                for (IdPAttributeValue theValue : inputValues) {
                    XMLObjectAttributeValue val = this.encodeOneValue(theValue, resolutionContext);
                    if (null == val) continue;
                    xmlVals.add(val);
                }
                if (0 == xmlVals.size()) {
                    this.log.warn("{} no appropriate values", (Object)this.getLogPrefix());
                    return null;
                }
                outputValues = xmlVals;
            }
        }
        result.setValues(outputValues);
        return result;
    }
}

