/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.attribute.resolver.impl;

import com.google.common.base.Strings;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.sql.DataSource;
import net.shibboleth.idp.attribute.IdPAttribute;
import net.shibboleth.idp.attribute.resolver.ResolutionException;
import net.shibboleth.idp.attribute.resolver.context.AttributeResolutionContext;
import net.shibboleth.idp.attribute.resolver.context.AttributeResolverWorkContext;
import net.shibboleth.idp.saml.attribute.resolver.impl.ComputedIDDataConnector;
import net.shibboleth.idp.saml.nameid.impl.JDBCPersistentIdStore;
import net.shibboleth.idp.saml.nameid.impl.StoredPersistentIdGenerationStrategy;
import net.shibboleth.utilities.java.support.annotation.Duration;
import net.shibboleth.utilities.java.support.annotation.constraint.NonNegative;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullAfterInit;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import org.opensaml.saml.common.SAMLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StoredIDDataConnector
extends ComputedIDDataConnector {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(StoredIDDataConnector.class);
    @Nonnull
    private final JDBCPersistentIdStore idStore = new JDBCPersistentIdStore();
    @Nonnull
    private final StoredPersistentIdGenerationStrategy storedIdStrategy = new StoredPersistentIdGenerationStrategy();

    public StoredIDDataConnector() {
        this.storedIdStrategy.setId("StoredPersistentIdGenerationStrategy");
        this.storedIdStrategy.setIDStore(this.idStore);
    }

    @NonnullAfterInit
    public DataSource getDataSource() {
        return this.idStore.getDataSource();
    }

    public void setDataSource(@Nonnull DataSource source) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.idStore.setDataSource(source);
    }

    @Nonnull
    public JDBCPersistentIdStore getStoredIDStore() {
        return this.idStore;
    }

    @NonNegative
    public long getQueryTimeout() {
        return this.idStore.getQueryTimeout();
    }

    public void setQueryTimeout(@Duration @NonNegative long timeout) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.idStore.setQueryTimeout(timeout);
    }

    @Override
    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        this.idStore.initialize();
        this.storedIdStrategy.setComputedIdStrategy(this.getComputedIdStrategy());
        this.storedIdStrategy.initialize();
    }

    @Override
    protected void doDestroy() {
        this.storedIdStrategy.destroy();
        this.idStore.destroy();
        super.doDestroy();
    }

    @Override
    @Nullable
    protected Map<String, IdPAttribute> doDataConnectorResolve(@Nonnull AttributeResolutionContext resolutionContext, @Nonnull AttributeResolverWorkContext workContext) throws ResolutionException {
        ComponentSupport.ifNotInitializedThrowUninitializedComponentException((InitializableComponent)this);
        String principalName = resolutionContext.getPrincipal();
        if (Strings.isNullOrEmpty((String)principalName)) {
            this.log.warn("{} No principal available, skipping ID creation", (Object)this.getLogPrefix());
            return null;
        }
        String sourceId = this.resolveSourceAttribute(workContext);
        if (Strings.isNullOrEmpty((String)sourceId)) {
            return null;
        }
        String attributeIssuerID = resolutionContext.getAttributeIssuerID();
        if (Strings.isNullOrEmpty((String)attributeIssuerID)) {
            this.log.warn("{} Could not get attribute issuer ID, skipping ID creation", (Object)this.getLogPrefix());
            return null;
        }
        String attributeRecipientID = resolutionContext.getAttributeRecipientID();
        if (Strings.isNullOrEmpty((String)attributeRecipientID)) {
            this.log.warn("{} Could not get attribute recipient ID, skipping ID creation", (Object)this.getLogPrefix());
            return null;
        }
        try {
            return this.encodeAsAttribute(this.storedIdStrategy.generate(attributeIssuerID, attributeRecipientID, principalName, sourceId));
        }
        catch (SAMLException e) {
            throw new ResolutionException((Exception)((Object)e));
        }
    }
}

