/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.metadata.impl;

import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import net.shibboleth.idp.attribute.resolver.AttributeResolver;
import net.shibboleth.idp.saml.attribute.mapping.AttributesMapContainer;
import net.shibboleth.idp.saml.attribute.mapping.impl.RequestedAttributesMapper;
import net.shibboleth.idp.saml.attribute.mapping.impl.SAML2AttributesMapper;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.service.ReloadableService;
import net.shibboleth.utilities.java.support.service.ServiceableComponent;
import org.joda.time.DateTime;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.saml.ext.saml2mdattr.EntityAttributes;
import org.opensaml.saml.metadata.resolver.filter.FilterException;
import org.opensaml.saml.metadata.resolver.filter.MetadataNodeProcessor;
import org.opensaml.saml.saml2.common.Extensions;
import org.opensaml.saml.saml2.metadata.AttributeConsumingService;
import org.opensaml.saml.saml2.metadata.EntityDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public class AttributeMappingNodeProcessor
implements MetadataNodeProcessor {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(AttributeMappingNodeProcessor.class);
    @Nonnull
    private final ReloadableService<AttributeResolver> attributeResolverService;
    @Nonnull
    private boolean refreshFailed;
    @Nullable
    private RequestedAttributesMapper requestedAttributesMapper;
    @Nullable
    private SAML2AttributesMapper attributesMapper;
    @Nullable
    private DateTime lastReload;

    public AttributeMappingNodeProcessor(@Nonnull ReloadableService<AttributeResolver> resolverService) {
        this.attributeResolverService = (ReloadableService)Constraint.isNotNull(resolverService, (String)"AttributeResolver cannot be null");
    }

    public RequestedAttributesMapper getRequestedAttributesMapper() {
        return this.requestedAttributesMapper;
    }

    public void setRequestedAttributesMapper(@Nullable RequestedAttributesMapper mapper) {
        this.requestedAttributesMapper = mapper;
    }

    public SAML2AttributesMapper getAttributesMapper() {
        return this.attributesMapper;
    }

    public void setAttributesMapper(@Nullable SAML2AttributesMapper mapper) {
        this.attributesMapper = mapper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void refreshMappers() throws FilterException {
        if (this.lastReload != null && this.lastReload.equals((Object)this.attributeResolverService.getLastSuccessfulReloadInstant())) {
            return;
        }
        ServiceableComponent component = null;
        RequestedAttributesMapper ram = null;
        SAML2AttributesMapper am = null;
        try {
            DateTime when = this.attributeResolverService.getLastSuccessfulReloadInstant();
            component = this.attributeResolverService.getServiceableComponent();
            if (null == component) {
                if (!this.refreshFailed) {
                    this.log.error("Requested Attributes Mapper: Invalid Attribute resolver configuration.");
                }
                this.refreshFailed = true;
            } else {
                AttributeResolver attributeResolver = (AttributeResolver)component.getComponent();
                ram = new RequestedAttributesMapper(attributeResolver);
                am = new SAML2AttributesMapper(attributeResolver);
                this.refreshFailed = false;
                this.lastReload = when;
            }
        }
        finally {
            if (null != component) {
                component.unpinComponent();
            }
        }
        try {
            if (null != ram) {
                ram.initialize();
            }
            if (null != am) {
                am.initialize();
            }
        }
        catch (ComponentInitializationException e) {
            throw new FilterException((Exception)((Object)e));
        }
        this.setRequestedAttributesMapper(ram);
        this.setAttributesMapper(am);
    }

    public void process(XMLObject metadataNode) throws FilterException {
        this.refreshMappers();
        if (metadataNode instanceof AttributeConsumingService) {
            this.handleAttributeConsumingService((AttributeConsumingService)metadataNode);
        } else if (metadataNode instanceof EntityDescriptor) {
            this.handleEntityDescriptor((EntityDescriptor)metadataNode);
        }
    }

    private void handleAttributeConsumingService(AttributeConsumingService acs) {
        List requestedAttributes = acs.getRequestAttributes();
        RequestedAttributesMapper mapper = this.getRequestedAttributesMapper();
        if (null == requestedAttributes || requestedAttributes.isEmpty() || null == mapper) {
            return;
        }
        Multimap maps = mapper.mapAttributes(requestedAttributes);
        if (null == maps || maps.isEmpty()) {
            return;
        }
        acs.getObjectMetadata().put((Object)new AttributesMapContainer(maps));
    }

    private void handleEntityDescriptor(EntityDescriptor entity) {
        SAML2AttributesMapper mapper = this.getAttributesMapper();
        Extensions extensions = entity.getExtensions();
        if (null == extensions || null == mapper) {
            return;
        }
        List entityAttributesList = extensions.getUnknownXMLObjects(EntityAttributes.DEFAULT_ELEMENT_NAME);
        if (null == entityAttributesList || entityAttributesList.isEmpty()) {
            return;
        }
        ArrayList entityAttributes = new ArrayList();
        for (XMLObject xmlObj : entityAttributesList) {
            if (!(xmlObj instanceof EntityAttributes)) continue;
            EntityAttributes ea = (EntityAttributes)xmlObj;
            entityAttributes.addAll(ea.getAttributes());
        }
        Multimap maps = mapper.mapAttributes(entityAttributes);
        if (null == maps || maps.isEmpty()) {
            return;
        }
        entity.getObjectMetadata().put((Object)new AttributesMapContainer(maps));
    }
}

