/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.nameid.impl;

import com.google.common.base.Strings;
import java.io.IOException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.saml.nameid.NameDecoderException;
import net.shibboleth.idp.saml.nameid.TransientIdParameters;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullAfterInit;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.component.AbstractIdentifiableInitializableComponent;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.opensaml.storage.StorageRecord;
import org.opensaml.storage.StorageService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseTransientDecoder
extends AbstractIdentifiableInitializableComponent {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(BaseTransientDecoder.class);
    @NonnullAfterInit
    private StorageService idStore;
    @Nullable
    private String logPrefix;

    @NonnullAfterInit
    public StorageService getIdStore() {
        return this.idStore;
    }

    public void setIdStore(@Nonnull StorageService store) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.idStore = (StorageService)Constraint.isNotNull((Object)store, (String)"StorageService cannot be null");
    }

    @Nullable
    public String decode(@Nonnull String transientId, @Nonnull @NotEmpty String requesterId) throws NameDecoderException {
        ComponentSupport.ifNotInitializedThrowUninitializedComponentException((InitializableComponent)this);
        if (null == transientId) {
            throw new NameDecoderException(this.getLogPrefix() + " Transient identifier was null");
        }
        if (Strings.isNullOrEmpty((String)requesterId)) {
            throw new NameDecoderException(this.getLogPrefix() + " Requester ID was null");
        }
        try {
            StorageRecord record = this.idStore.read("TransientId", transientId);
            if (null == record) {
                this.log.info("{} Could not find transient identifier", (Object)this.getLogPrefix());
                return null;
            }
            TransientIdParameters param = new TransientIdParameters(record.getValue());
            if (!requesterId.equals(param.getAttributeRecipient())) {
                this.log.warn("{} Transient identifier issued to {} but requested by {}", new Object[]{this.getLogPrefix(), param.getAttributeRecipient(), requesterId});
                throw new NameDecoderException("Misuse of identifier by an improper relying party");
            }
            return param.getPrincipal();
        }
        catch (IOException e) {
            this.log.error(this.getLogPrefix() + " I/O error looking up transient identifier", (Throwable)e);
            return null;
        }
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (null == this.idStore) {
            throw new ComponentInitializationException(this.getLogPrefix() + " No Id store set");
        }
        this.log.debug("{} using the store '{}'", (Object)this.getLogPrefix(), (Object)this.idStore.getId());
    }

    @Nonnull
    @NotEmpty
    protected String getLogPrefix() {
        String prefix = this.logPrefix;
        if (null == prefix) {
            StringBuilder builder = new StringBuilder("Transient Decoder '").append(this.getId()).append("':");
            prefix = builder.toString();
            if (null == this.logPrefix) {
                this.logPrefix = prefix;
            }
        }
        return prefix;
    }
}

