/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.nameid.impl;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import javax.annotation.Nonnull;
import net.shibboleth.idp.saml.nameid.impl.PersistentIdGenerationStrategy;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullAfterInit;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.codec.Base64Support;
import net.shibboleth.utilities.java.support.component.AbstractIdentifiableInitializableComponent;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import org.opensaml.saml.common.SAMLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ComputedPersistentIdGenerationStrategy
extends AbstractIdentifiableInitializableComponent
implements PersistentIdGenerationStrategy {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(ComputedPersistentIdGenerationStrategy.class);
    @NonnullAfterInit
    private byte[] salt;
    @Nonnull
    @NotEmpty
    private String algorithm = "SHA";

    @NonnullAfterInit
    public byte[] getSalt() {
        return this.salt;
    }

    public void setSalt(@Nonnull @NotEmpty byte[] newValue) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.salt = Constraint.isNotEmpty((byte[])newValue, (String)"Salt cannot be null or empty");
    }

    public void setAlgorithm(@Nonnull @NotEmpty String alg) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.algorithm = (String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)alg), (String)"Digest algorithm cannot be null or empty");
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (null == this.getSalt()) {
            throw new ComponentInitializationException("Salt cannot be null");
        }
        if (this.getSalt().length < 16) {
            throw new ComponentInitializationException("Salt must be at least 16 bytes in size");
        }
    }

    @Override
    @Nonnull
    @NotEmpty
    public String generate(@Nonnull @NotEmpty String assertingPartyId, @Nonnull @NotEmpty String relyingPartyId, @Nonnull @NotEmpty String principalName, @Nonnull @NotEmpty String sourceId) throws SAMLException {
        ComponentSupport.ifNotInitializedThrowUninitializedComponentException((InitializableComponent)this);
        try {
            MessageDigest md = MessageDigest.getInstance(this.algorithm);
            md.update(relyingPartyId.getBytes());
            md.update((byte)33);
            md.update(sourceId.getBytes());
            md.update((byte)33);
            return Base64Support.encode((byte[])md.digest(this.salt), (boolean)false);
        }
        catch (NoSuchAlgorithmException e) {
            this.log.error("Digest algorithm {} is not supported", (Object)this.algorithm);
            throw new SAMLException("Digest algorithm was not supported, unable to compute ID", (Exception)e);
        }
    }
}

