/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.profile.config.logic;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.profile.context.RelyingPartyContext;
import net.shibboleth.idp.saml.saml1.profile.config.BrowserSSOProfileConfiguration;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.profile.context.ProfileRequestContext;

public class ResolveAttributesProfileConfigPredicate
implements Predicate<ProfileRequestContext> {
    @Nonnull
    private Function<ProfileRequestContext, RelyingPartyContext> relyingPartyContextLookupStrategy = new ChildContextLookup(RelyingPartyContext.class);

    public void setRelyingPartyContextLookupStrategy(@Nonnull Function<ProfileRequestContext, RelyingPartyContext> strategy) {
        this.relyingPartyContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"RelyingPartyContext lookup strategy cannot be null");
    }

    public boolean apply(@Nullable ProfileRequestContext input) {
        RelyingPartyContext rpc;
        if (input != null && (rpc = (RelyingPartyContext)this.relyingPartyContextLookupStrategy.apply((Object)input)) != null) {
            if (rpc.getProfileConfig() instanceof BrowserSSOProfileConfiguration) {
                return ((BrowserSSOProfileConfiguration)rpc.getProfileConfig()).resolveAttributes();
            }
            if (rpc.getProfileConfig() instanceof net.shibboleth.idp.saml.saml2.profile.config.BrowserSSOProfileConfiguration) {
                return ((net.shibboleth.idp.saml.saml2.profile.config.BrowserSSOProfileConfiguration)rpc.getProfileConfig()).resolveAttributes();
            }
        }
        return false;
    }
}

