/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.profile.impl;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.profile.AbstractProfileAction;
import net.shibboleth.idp.profile.context.RelyingPartyContext;
import net.shibboleth.idp.saml.profile.impl.SAMLAnonymityLookupStrategy;
import net.shibboleth.idp.saml.profile.impl.SAMLRelyingPartyIdLookupStrategy;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.opensaml.messaging.context.BaseContext;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.profile.context.navigate.InboundMessageContextLookup;
import org.opensaml.saml.common.messaging.context.SAMLPeerEntityContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InitializeRelyingPartyContextFromSAMLPeer
extends AbstractProfileAction {
    @Nonnull
    private static final Function<RelyingPartyContext, String> RPID_LOOKUP = new SAMLRelyingPartyIdLookupStrategy();
    @Nonnull
    private static final Function<RelyingPartyContext, Boolean> ANON_LOOKUP = new SAMLAnonymityLookupStrategy();
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(InitializeRelyingPartyContextFromSAMLPeer.class);
    @Nonnull
    private Function<ProfileRequestContext, RelyingPartyContext> relyingPartyContextCreationStrategy = new ChildContextLookup(RelyingPartyContext.class, true);
    @Nonnull
    private Function<ProfileRequestContext, SAMLPeerEntityContext> peerEntityContextLookupStrategy = Functions.compose((Function)new ChildContextLookup(SAMLPeerEntityContext.class), (Function)new InboundMessageContextLookup());
    @Nullable
    private SAMLPeerEntityContext peerEntityCtx;

    public void setRelyingPartyContextCreationStrategy(@Nonnull Function<ProfileRequestContext, RelyingPartyContext> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.relyingPartyContextCreationStrategy = (Function)Constraint.isNotNull(strategy, (String)"RelyingPartyContext creation strategy cannot be null");
    }

    public void setPeerEntityContextLookupStrategy(@Nonnull Function<ProfileRequestContext, SAMLPeerEntityContext> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.peerEntityContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"SAMLPeerEntityContext lookup strategy cannot be null");
    }

    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        this.peerEntityCtx = (SAMLPeerEntityContext)this.peerEntityContextLookupStrategy.apply((Object)profileRequestContext);
        if (this.peerEntityCtx == null) {
            this.log.debug("{} Unable to locate SAMLPeerEntityContext", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileContext");
            return false;
        }
        return super.doPreExecute(profileRequestContext);
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        RelyingPartyContext rpContext = (RelyingPartyContext)this.relyingPartyContextCreationStrategy.apply((Object)profileRequestContext);
        if (rpContext == null) {
            this.log.debug("{} Unable to locate or create RelyingPartyContext", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidRelyingPartyContext");
            return;
        }
        this.log.debug("{} Attaching RelyingPartyContext based on SAML peer {}", (Object)this.getLogPrefix(), (Object)this.peerEntityCtx.getEntityId());
        rpContext.setRelyingPartyIdContextTree((BaseContext)this.peerEntityCtx);
        rpContext.setRelyingPartyIdLookupStrategy(RPID_LOOKUP);
        rpContext.setAnonymityLookupStrategy(ANON_LOOKUP);
    }
}

