/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.profile.logic;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.profile.context.RelyingPartyContext;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import org.opensaml.messaging.context.BaseContext;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.messaging.context.navigate.ContextDataLookupFunction;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.saml.common.messaging.context.SAMLMetadataContext;
import org.opensaml.saml.common.messaging.context.SAMLPeerEntityContext;
import org.opensaml.saml.metadata.EntityGroupName;

public class EntitiesDescriptorPredicate
implements Predicate<ProfileRequestContext> {
    @Nonnull
    private Function<ProfileRequestContext, SAMLMetadataContext> metadataContextLookupStrategy;
    @Nonnull
    @NotEmpty
    private final String groupName;

    public EntitiesDescriptorPredicate(@Nonnull @NotEmpty String name) {
        this.groupName = (String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)name), (String)"Group name cannot be null or empty");
        this.metadataContextLookupStrategy = Functions.compose((Function)Functions.compose((Function)new ChildContextLookup(SAMLMetadataContext.class), (Function)new SAMLPeerEntityLookup()), (Function)new ChildContextLookup(RelyingPartyContext.class));
    }

    public void setMetadataContextLookupStrategy(@Nonnull Function<ProfileRequestContext, SAMLMetadataContext> strategy) {
        this.metadataContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"SAMLMetadataContext lookup strategy cannot be null");
    }

    public boolean apply(@Nullable ProfileRequestContext input) {
        SAMLMetadataContext metadataCtx = (SAMLMetadataContext)this.metadataContextLookupStrategy.apply((Object)input);
        if (metadataCtx != null && metadataCtx.getEntityDescriptor() != null) {
            for (EntityGroupName group : metadataCtx.getEntityDescriptor().getObjectMetadata().get(EntityGroupName.class)) {
                if (!group.getName().equals(this.groupName)) continue;
                return true;
            }
        }
        return false;
    }

    private class SAMLPeerEntityLookup
    implements ContextDataLookupFunction<RelyingPartyContext, SAMLPeerEntityContext> {
        private SAMLPeerEntityLookup() {
        }

        @Nullable
        public SAMLPeerEntityContext apply(@Nullable RelyingPartyContext input) {
            BaseContext peer;
            if (input != null && (peer = input.getRelyingPartyIdContextTree()) != null && peer instanceof SAMLPeerEntityContext) {
                return (SAMLPeerEntityContext)peer;
            }
            return null;
        }
    }
}

