/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.profile.logic;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.profile.context.RelyingPartyContext;
import net.shibboleth.idp.saml.saml1.profile.config.BrowserSSOProfileConfiguration;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.profile.context.navigate.OutboundMessageContextLookup;
import org.opensaml.saml.common.messaging.context.SAMLBindingContext;

public class IncludeAttributeStatementPredicate
implements Predicate<ProfileRequestContext> {
    @Nonnull
    private Function<ProfileRequestContext, RelyingPartyContext> relyingPartyContextLookupStrategy = new ChildContextLookup(RelyingPartyContext.class);
    @Nonnull
    private Function<ProfileRequestContext, SAMLBindingContext> bindingContextLookupStrategy = Functions.compose((Function)new ChildContextLookup(SAMLBindingContext.class), (Function)new OutboundMessageContextLookup());

    public void setRelyingPartyContextLookupStrategy(@Nonnull Function<ProfileRequestContext, RelyingPartyContext> strategy) {
        this.relyingPartyContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"RelyingPartyContext lookup strategy cannot be null");
    }

    public void setBindingContextLookupStrategy(@Nonnull Function<ProfileRequestContext, SAMLBindingContext> strategy) {
        this.bindingContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"SAMLBindingContext lookup strategy cannot be null");
    }

    public boolean apply(@Nullable ProfileRequestContext input) {
        RelyingPartyContext rpc;
        SAMLBindingContext bindingCtx = (SAMLBindingContext)this.bindingContextLookupStrategy.apply((Object)input);
        if (bindingCtx != null && bindingCtx.getBindingDescriptor() != null && bindingCtx.getBindingDescriptor().isArtifact()) {
            return true;
        }
        if (input != null && (rpc = (RelyingPartyContext)this.relyingPartyContextLookupStrategy.apply((Object)input)) != null && rpc.getProfileConfig() != null) {
            if (rpc.getProfileConfig() instanceof BrowserSSOProfileConfiguration) {
                return ((BrowserSSOProfileConfiguration)rpc.getProfileConfig()).includeAttributeStatement();
            }
            if (rpc.getProfileConfig() instanceof net.shibboleth.idp.saml.saml2.profile.config.BrowserSSOProfileConfiguration) {
                return ((net.shibboleth.idp.saml.saml2.profile.config.BrowserSSOProfileConfiguration)rpc.getProfileConfig()).includeAttributeStatement();
            }
        }
        return false;
    }
}

