/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.relyingparty.impl;

import com.google.common.base.Predicate;
import java.util.Collection;
import javax.annotation.Nonnull;
import net.shibboleth.idp.profile.logic.RelyingPartyIdPredicate;
import net.shibboleth.idp.relyingparty.RelyingPartyConfiguration;
import net.shibboleth.idp.saml.profile.logic.EntitiesDescriptorPredicate;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;

public final class RelyingPartyConfigurationSupport {
    private RelyingPartyConfigurationSupport() {
    }

    @Nonnull
    public static RelyingPartyConfiguration byName(@Nonnull @NonnullElements Collection<String> relyingPartyIds) {
        RelyingPartyConfiguration config = new RelyingPartyConfiguration();
        config.setActivationCondition((Predicate)new RelyingPartyIdPredicate(relyingPartyIds));
        if (relyingPartyIds.size() == 1) {
            config.setId(relyingPartyIds.iterator().next());
        }
        return config;
    }

    @Nonnull
    public static RelyingPartyConfiguration byGroup(@Nonnull @NotEmpty String name) {
        RelyingPartyConfiguration config = new RelyingPartyConfiguration();
        config.setId(name);
        config.setActivationCondition((Predicate)new EntitiesDescriptorPredicate(name));
        return config;
    }
}

