/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.saml1.profile.impl;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.saml.profile.impl.BaseIdPInitiatedSSORequestMessageDecoder;
import net.shibboleth.idp.saml.profile.impl.IdPInitiatedSSORequest;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import org.joda.time.Chronology;
import org.joda.time.DateTime;
import org.joda.time.chrono.ISOChronology;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.decoder.MessageDecodingException;
import org.opensaml.saml.common.messaging.context.SAMLBindingContext;
import org.opensaml.saml.common.messaging.context.SAMLMessageInfoContext;
import org.opensaml.saml.common.messaging.context.SAMLPeerEntityContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IdPInitiatedSSORequestMessageDecoder
extends BaseIdPInitiatedSSORequestMessageDecoder<IdPInitiatedSSORequest> {
    @Nonnull
    @NotEmpty
    private static final String BINDING_URI = "urn:mace:shibboleth:1.0:profiles:AuthnRequest";
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(IdPInitiatedSSORequestMessageDecoder.class);

    @Nonnull
    @NotEmpty
    public String getBindingURI() {
        return BINDING_URI;
    }

    protected void doDecode() throws MessageDecodingException {
        IdPInitiatedSSORequest ssoRequest = this.buildIdPInitiatedSSORequest();
        MessageContext messageContext = new MessageContext();
        messageContext.setMessage((Object)ssoRequest);
        ((SAMLPeerEntityContext)messageContext.getSubcontext(SAMLPeerEntityContext.class, true)).setEntityId(ssoRequest.getEntityId());
        SAMLMessageInfoContext msgInfoContext = (SAMLMessageInfoContext)messageContext.getSubcontext(SAMLMessageInfoContext.class, true);
        msgInfoContext.setMessageIssueInstant(new DateTime(ssoRequest.getTime(), (Chronology)ISOChronology.getInstanceUTC()));
        msgInfoContext.setMessageId(this.getMessageID());
        this.populateBindingContext((MessageContext<IdPInitiatedSSORequest>)messageContext);
        this.setMessageContext(messageContext);
    }

    protected void populateBindingContext(@Nonnull MessageContext<IdPInitiatedSSORequest> messageContext) {
        String relayState = ((IdPInitiatedSSORequest)messageContext.getMessage()).getRelayState();
        this.log.debug("Decoded SAML relay state: {}", (Object)relayState);
        SAMLBindingContext bindingContext = (SAMLBindingContext)messageContext.getSubcontext(SAMLBindingContext.class, true);
        bindingContext.setRelayState(relayState);
        bindingContext.setBindingUri(this.getBindingURI());
        bindingContext.setHasBindingSignature(false);
        bindingContext.setIntendedDestinationEndpointURIRequired(false);
    }

    @Override
    @Nullable
    protected String getMessageToLog() {
        return "SAML 1 IdP-initiated request was: " + ((IdPInitiatedSSORequest)this.getMessageContext().getMessage()).toString();
    }
}

