/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.saml2.profile.impl;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.attribute.AttributeEncoder;
import net.shibboleth.idp.attribute.AttributeEncodingException;
import net.shibboleth.idp.attribute.IdPAttribute;
import net.shibboleth.idp.attribute.context.AttributeContext;
import net.shibboleth.idp.profile.AbstractProfileAction;
import net.shibboleth.idp.profile.config.navigate.IdentifierGenerationStrategyLookupFunction;
import net.shibboleth.idp.profile.context.RelyingPartyContext;
import net.shibboleth.idp.profile.context.navigate.ResponderIdLookupFunction;
import net.shibboleth.idp.saml.attribute.encoding.SAML2AttributeEncoder;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullAfterInit;
import net.shibboleth.utilities.java.support.annotation.constraint.NullableElements;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.security.IdentifierGenerationStrategy;
import org.opensaml.core.xml.config.XMLObjectProviderRegistrySupport;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.messaging.context.navigate.MessageLookup;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.profile.context.navigate.OutboundMessageContextLookup;
import org.opensaml.saml.common.SAMLObjectBuilder;
import org.opensaml.saml.saml2.core.Assertion;
import org.opensaml.saml.saml2.core.Attribute;
import org.opensaml.saml.saml2.core.AttributeStatement;
import org.opensaml.saml.saml2.core.Response;
import org.opensaml.saml.saml2.profile.SAML2ActionSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AddAttributeStatementToAssertion
extends AbstractProfileAction {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(AddAttributeStatementToAssertion.class);
    private boolean statementInOwnAssertion = false;
    private boolean ignoringUnencodableAttributes = true;
    @NonnullAfterInit
    private Function<ProfileRequestContext, IdentifierGenerationStrategy> idGeneratorLookupStrategy;
    @Nullable
    private Function<ProfileRequestContext, String> issuerLookupStrategy;
    @Nonnull
    private Function<ProfileRequestContext, AttributeContext> attributeContextLookupStrategy = Functions.compose((Function)new ChildContextLookup(AttributeContext.class), (Function)new ChildContextLookup(RelyingPartyContext.class));
    @Nonnull
    private Function<ProfileRequestContext, Response> responseLookupStrategy = Functions.compose((Function)new MessageLookup(Response.class), (Function)new OutboundMessageContextLookup());
    @Nullable
    private AttributeContext attributeCtx;
    @Nullable
    private IdentifierGenerationStrategy idGenerator;
    @Nullable
    private String issuerId;
    @Nullable
    private Response response;

    public AddAttributeStatementToAssertion() {
        this.idGeneratorLookupStrategy = new IdentifierGenerationStrategyLookupFunction();
        this.issuerLookupStrategy = new ResponderIdLookupFunction();
    }

    public void setStatementInOwnAssertion(boolean flag) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.statementInOwnAssertion = flag;
    }

    public void setIgnoringUnencodableAttributes(boolean flag) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.ignoringUnencodableAttributes = flag;
    }

    public void setAttributeContextLookupStrategy(@Nonnull Function<ProfileRequestContext, AttributeContext> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.attributeContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"AttributeContext lookup strategy cannot be null");
    }

    public void setResponseLookupStrategy(@Nonnull Function<ProfileRequestContext, Response> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.responseLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Response lookup strategy cannot be null");
    }

    public void setIdentifierGeneratorLookupStrategy(@Nonnull Function<ProfileRequestContext, IdentifierGenerationStrategy> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.idGeneratorLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"IdentifierGenerationStrategy lookup strategy cannot be null");
    }

    public void setIssuerLookupStrategy(@Nonnull Function<ProfileRequestContext, String> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.issuerLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Issuer lookup strategy cannot be null");
    }

    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        this.log.debug("{} Attempting to add an AttributeStatement to outgoing Response", (Object)this.getLogPrefix());
        this.idGenerator = (IdentifierGenerationStrategy)this.idGeneratorLookupStrategy.apply((Object)profileRequestContext);
        if (this.idGenerator == null) {
            this.log.debug("{} No identifier generation strategy", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileContext");
            return false;
        }
        this.issuerId = (String)this.issuerLookupStrategy.apply((Object)profileRequestContext);
        if (this.issuerId == null) {
            this.log.debug("{} No assertion issuer value", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileContext");
            return false;
        }
        this.attributeCtx = (AttributeContext)this.attributeContextLookupStrategy.apply((Object)profileRequestContext);
        if (this.attributeCtx == null) {
            this.log.debug("{} No AttributeSubcontext available, nothing to do", (Object)this.getLogPrefix());
            return false;
        }
        this.response = (Response)this.responseLookupStrategy.apply((Object)profileRequestContext);
        if (this.response == null) {
            this.log.debug("{} No SAML response located in current profile request context", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidMessageContext");
            return false;
        }
        return super.doPreExecute(profileRequestContext);
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        try {
            AttributeStatement statement = this.buildAttributeStatement(profileRequestContext, this.attributeCtx.getIdPAttributes().values());
            if (statement == null) {
                this.log.debug("{} No AttributeStatement was built, nothing to do", (Object)this.getLogPrefix());
                return;
            }
            Assertion assertion = this.getStatementAssertion();
            assertion.getAttributeStatements().add(statement);
            this.log.debug("{} Adding constructed AttributeStatement to Assertion {} ", (Object)this.getLogPrefix(), (Object)assertion.getID());
        }
        catch (AttributeEncodingException e) {
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"UnableToEncodeAttribute");
        }
    }

    @Nonnull
    private Assertion getStatementAssertion() {
        if (this.statementInOwnAssertion || this.response.getAssertions().isEmpty()) {
            return SAML2ActionSupport.addAssertionToResponse((org.opensaml.profile.action.AbstractProfileAction)this, (Response)this.response, (IdentifierGenerationStrategy)this.idGenerator, (String)this.issuerId);
        }
        return (Assertion)this.response.getAssertions().get(0);
    }

    @Nullable
    private AttributeStatement buildAttributeStatement(@Nonnull ProfileRequestContext profileRequestContext, @Nullable @NullableElements Collection<IdPAttribute> attributes) throws AttributeEncodingException {
        if (attributes == null || attributes.isEmpty()) {
            this.log.debug("{} No attributes available to be encoded, nothing to do", (Object)this.getLogPrefix());
            return null;
        }
        ArrayList encodedAttributes = Lists.newArrayListWithExpectedSize((int)attributes.size());
        for (IdPAttribute attribute : Collections2.filter(attributes, (Predicate)Predicates.notNull())) {
            Attribute encodedAttribute = this.encodeAttribute(profileRequestContext, attribute);
            if (encodedAttribute == null) continue;
            encodedAttributes.add(encodedAttribute);
        }
        if (encodedAttributes.isEmpty()) {
            this.log.debug("{} No attributes were encoded as SAML 2 Attributes, nothing to do", (Object)this.getLogPrefix());
            return null;
        }
        SAMLObjectBuilder statementBuilder = (SAMLObjectBuilder)XMLObjectProviderRegistrySupport.getBuilderFactory().getBuilderOrThrow(AttributeStatement.DEFAULT_ELEMENT_NAME);
        AttributeStatement statement = (AttributeStatement)statementBuilder.buildObject();
        statement.getAttributes().addAll(encodedAttributes);
        return statement;
    }

    @Nullable
    private Attribute encodeAttribute(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull IdPAttribute attribute) throws AttributeEncodingException {
        this.log.debug("{} Attempting to encode attribute {} as a SAML 2 Attribute", (Object)this.getLogPrefix(), (Object)attribute.getId());
        Set encoders = attribute.getEncoders();
        if (encoders.isEmpty()) {
            this.log.debug("{} Attribute {} does not have any encoders, nothing to do", (Object)this.getLogPrefix(), (Object)attribute.getId());
            return null;
        }
        for (AttributeEncoder encoder : encoders) {
            if (!"urn:oasis:names:tc:SAML:2.0:protocol".equals(encoder.getProtocol()) || !(encoder instanceof SAML2AttributeEncoder) || !encoder.getActivationCondition().apply((Object)profileRequestContext)) continue;
            this.log.debug("{} Encoding attribute {} as a SAML 2 Attribute", (Object)this.getLogPrefix(), (Object)attribute.getId());
            try {
                return (Attribute)encoder.encode(attribute);
            }
            catch (AttributeEncodingException e) {
                if (this.ignoringUnencodableAttributes) {
                    this.log.debug(this.getLogPrefix() + " Unable to encode attribute " + attribute.getId() + "as SAML 2 attribute", (Throwable)e);
                    continue;
                }
                throw e;
            }
        }
        this.log.debug("{} Attribute {} did not have a usable SAML 2 Attribute encoder associated with it, nothing to do", (Object)this.getLogPrefix(), (Object)attribute.getId());
        return null;
    }
}

