/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.saml2.profile.impl;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import java.security.Principal;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.authn.AbstractAuthenticationAction;
import net.shibboleth.idp.authn.AuthenticationResult;
import net.shibboleth.idp.authn.context.AuthenticationContext;
import net.shibboleth.idp.authn.context.RequestedPrincipalContext;
import net.shibboleth.idp.authn.principal.DefaultPrincipalDeterminationStrategy;
import net.shibboleth.idp.profile.config.navigate.IdentifierGenerationStrategyLookupFunction;
import net.shibboleth.idp.profile.context.navigate.ResponderIdLookupFunction;
import net.shibboleth.idp.saml.authn.principal.AuthnContextClassRefPrincipal;
import net.shibboleth.idp.saml.authn.principal.AuthnContextDeclRefPrincipal;
import net.shibboleth.idp.saml.profile.config.navigate.SessionLifetimeLookupFunction;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullAfterInit;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.security.IdentifierGenerationStrategy;
import org.joda.time.DateTime;
import org.opensaml.core.xml.XMLObjectBuilderFactory;
import org.opensaml.core.xml.config.XMLObjectProviderRegistrySupport;
import org.opensaml.messaging.context.navigate.MessageLookup;
import org.opensaml.profile.action.AbstractProfileAction;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.profile.context.navigate.OutboundMessageContextLookup;
import org.opensaml.saml.common.SAMLObjectBuilder;
import org.opensaml.saml.saml2.core.Assertion;
import org.opensaml.saml.saml2.core.AuthnContext;
import org.opensaml.saml.saml2.core.AuthnStatement;
import org.opensaml.saml.saml2.core.Response;
import org.opensaml.saml.saml2.core.SubjectLocality;
import org.opensaml.saml.saml2.profile.SAML2ActionSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AddAuthnStatementToAssertion
extends AbstractAuthenticationAction {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(AddAuthnStatementToAssertion.class);
    private boolean statementInOwnAssertion = false;
    @Nonnull
    private Function<ProfileRequestContext, Response> responseLookupStrategy = Functions.compose((Function)new MessageLookup(Response.class), (Function)new OutboundMessageContextLookup());
    @NonnullAfterInit
    private Function<ProfileRequestContext, IdentifierGenerationStrategy> idGeneratorLookupStrategy = new IdentifierGenerationStrategyLookupFunction();
    @Nullable
    private Function<ProfileRequestContext, String> issuerLookupStrategy = new ResponderIdLookupFunction();
    @Nonnull
    private Function<ProfileRequestContext, AuthnContextClassRefPrincipal> classRefLookupStrategy = new DefaultPrincipalDeterminationStrategy(AuthnContextClassRefPrincipal.class, (Principal)new AuthnContextClassRefPrincipal("urn:oasis:names:tc:SAML:2.0:ac:classes:unspecified"));
    @Nullable
    private Function<ProfileRequestContext, Long> sessionLifetimeLookupStrategy = new SessionLifetimeLookupFunction();
    @Nullable
    private IdentifierGenerationStrategy idGenerator;
    @Nullable
    private AuthenticationResult authenticationResult;
    @Nullable
    private Response response;
    @Nullable
    private String issuerId;

    public void setStatementInOwnAssertion(boolean inOwnAssertion) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.statementInOwnAssertion = inOwnAssertion;
    }

    public void setResponseLookupStrategy(@Nonnull Function<ProfileRequestContext, Response> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.responseLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Response lookup strategy cannot be null");
    }

    public void setIdentifierGeneratorLookupStrategy(@Nonnull Function<ProfileRequestContext, IdentifierGenerationStrategy> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.idGeneratorLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"IdentifierGenerationStrategy lookup strategy cannot be null");
    }

    public void setIssuerLookupStrategy(@Nonnull Function<ProfileRequestContext, String> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.issuerLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Issuer lookup strategy cannot be null");
    }

    public void setClassRefLookupStrategy(@Nonnull Function<ProfileRequestContext, AuthnContextClassRefPrincipal> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.classRefLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Authentication context class reference strategy cannot be null");
    }

    public void setSessionLifetimeLookupStrategy(@Nullable Function<ProfileRequestContext, Long> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.sessionLifetimeLookupStrategy = strategy;
    }

    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull AuthenticationContext authenticationContext) {
        this.log.debug("{} Attempting to add an AuthnStatement to Response", (Object)this.getLogPrefix());
        this.idGenerator = (IdentifierGenerationStrategy)this.idGeneratorLookupStrategy.apply((Object)profileRequestContext);
        if (this.idGenerator == null) {
            this.log.debug("{} No identifier generation strategy", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileContext");
            return false;
        }
        this.issuerId = (String)this.issuerLookupStrategy.apply((Object)profileRequestContext);
        if (this.issuerId == null) {
            this.log.debug("{} No assertion issuer value", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileContext");
            return false;
        }
        this.authenticationResult = authenticationContext.getAuthenticationResult();
        if (this.authenticationResult == null) {
            this.log.debug("{} No AuthenticationResult in current authentication context", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidAuthenticationContext");
            return false;
        }
        this.response = (Response)this.responseLookupStrategy.apply((Object)profileRequestContext);
        if (this.response == null) {
            this.log.debug("{} No SAML response located in current profile request context", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidMessageContext");
            return false;
        }
        return super.doPreExecute(profileRequestContext, authenticationContext);
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull AuthenticationContext authenticationContext) {
        Assertion assertion = this.getStatementAssertion();
        AuthnStatement statement = this.buildAuthnStatement(profileRequestContext, (RequestedPrincipalContext)authenticationContext.getSubcontext(RequestedPrincipalContext.class, false));
        assertion.getAuthnStatements().add(statement);
        this.log.debug("{} Added AuthenticationStatement to assertion {}", (Object)this.getLogPrefix(), (Object)assertion.getID());
    }

    @Nonnull
    private Assertion getStatementAssertion() {
        if (this.statementInOwnAssertion || this.response.getAssertions().isEmpty()) {
            return SAML2ActionSupport.addAssertionToResponse((AbstractProfileAction)this, (Response)this.response, (IdentifierGenerationStrategy)this.idGenerator, (String)this.issuerId);
        }
        return (Assertion)this.response.getAssertions().get(0);
    }

    @Nonnull
    private AuthnStatement buildAuthnStatement(@Nonnull ProfileRequestContext profileRequestContext, @Nullable RequestedPrincipalContext requestedPrincipalContext) {
        Long lifetime;
        XMLObjectBuilderFactory bf = XMLObjectProviderRegistrySupport.getBuilderFactory();
        SAMLObjectBuilder statementBuilder = (SAMLObjectBuilder)bf.getBuilderOrThrow(AuthnStatement.TYPE_NAME);
        SAMLObjectBuilder authnContextBuilder = (SAMLObjectBuilder)bf.getBuilderOrThrow(AuthnContext.TYPE_NAME);
        SAMLObjectBuilder localityBuilder = (SAMLObjectBuilder)bf.getBuilderOrThrow(SubjectLocality.TYPE_NAME);
        AuthnStatement statement = (AuthnStatement)statementBuilder.buildObject();
        statement.setAuthnInstant(new DateTime(this.authenticationResult.getAuthenticationInstant()));
        AuthnContext authnContext = (AuthnContext)authnContextBuilder.buildObject();
        statement.setAuthnContext(authnContext);
        if (requestedPrincipalContext != null && requestedPrincipalContext.getMatchingPrincipal() != null) {
            Principal matchingPrincipal = requestedPrincipalContext.getMatchingPrincipal();
            if (matchingPrincipal instanceof AuthnContextClassRefPrincipal) {
                authnContext.setAuthnContextClassRef(((AuthnContextClassRefPrincipal)matchingPrincipal).getAuthnContextClassRef());
            } else if (matchingPrincipal instanceof AuthnContextDeclRefPrincipal) {
                authnContext.setAuthnContextDeclRef(((AuthnContextDeclRefPrincipal)matchingPrincipal).getAuthnContextDeclRef());
            } else {
                authnContext.setAuthnContextClassRef(((AuthnContextClassRefPrincipal)this.classRefLookupStrategy.apply((Object)profileRequestContext)).getAuthnContextClassRef());
            }
        } else {
            authnContext.setAuthnContextClassRef(((AuthnContextClassRefPrincipal)this.classRefLookupStrategy.apply((Object)profileRequestContext)).getAuthnContextClassRef());
        }
        if (this.sessionLifetimeLookupStrategy != null && (lifetime = (Long)this.sessionLifetimeLookupStrategy.apply((Object)profileRequestContext)) != null && lifetime > 0L) {
            statement.setSessionNotOnOrAfter(new DateTime().plus(lifetime.longValue()));
        }
        statement.setSessionIndex(this.idGenerator.generateIdentifier());
        if (this.getHttpServletRequest() != null) {
            SubjectLocality locality = (SubjectLocality)localityBuilder.buildObject();
            locality.setAddress(this.getHttpServletRequest().getRemoteAddr());
            statement.setSubjectLocality(locality);
        } else {
            this.log.debug("{} HttpServletRequest not available, omitting SubjectLocality element", (Object)this.getLogPrefix());
        }
        return statement;
    }
}

