/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.security.impl;

import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import net.shibboleth.idp.saml.security.KeyAuthoritySupport;
import net.shibboleth.idp.saml.xmlobject.KeyAuthority;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.saml.metadata.resolver.filter.FilterException;
import org.opensaml.saml.metadata.resolver.filter.MetadataNodeProcessor;
import org.opensaml.saml.saml2.common.Extensions;
import org.opensaml.saml.saml2.metadata.EntitiesDescriptor;
import org.opensaml.saml.saml2.metadata.EntityDescriptor;
import org.opensaml.security.SecurityException;
import org.opensaml.security.x509.PKIXValidationInformation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeyAuthorityNodeProcessor
implements MetadataNodeProcessor {
    private Logger log = LoggerFactory.getLogger(KeyAuthority.class);

    public void process(XMLObject metadataNode) throws FilterException {
        if (metadataNode instanceof EntitiesDescriptor) {
            this.handleEntitiesDescriptor((EntitiesDescriptor)metadataNode);
        } else if (metadataNode instanceof EntityDescriptor) {
            this.handleEntityDescriptor((EntityDescriptor)metadataNode);
        }
    }

    protected void handleEntitiesDescriptor(EntitiesDescriptor entitiesDescriptor) throws FilterException {
        this.log.debug("Processing EntitiesDescriptor with id '{}', name '{}'", (Object)entitiesDescriptor.getID(), (Object)entitiesDescriptor.getName());
        List<XMLObject> keyAuthorities = this.getKeyAuthorities(entitiesDescriptor);
        if (keyAuthorities.isEmpty()) {
            return;
        }
        this.log.debug("Saw at least one KeyAuthority for EntitiesDescriptor with id '{}', name '{}'", (Object)entitiesDescriptor.getID(), (Object)entitiesDescriptor.getName());
        for (XMLObject keyAuthority : keyAuthorities) {
            try {
                PKIXValidationInformation pkixInfo = KeyAuthoritySupport.extractPKIXValidationInfo((KeyAuthority)((KeyAuthority)keyAuthority));
                if (pkixInfo == null) continue;
                keyAuthority.getObjectMetadata().put((Object)pkixInfo);
            }
            catch (SecurityException e) {
                throw new FilterException("Error extracting PKIX validation info from KeyAuthority", (Exception)((Object)e));
            }
        }
    }

    protected void handleEntityDescriptor(EntityDescriptor entityDescriptor) throws FilterException {
        for (XMLObject currentParent = entityDescriptor.getParent(); currentParent != null; currentParent = currentParent.getParent()) {
            if (!(currentParent instanceof EntitiesDescriptor)) continue;
            for (XMLObject keyAuthority : this.getKeyAuthorities((EntitiesDescriptor)currentParent)) {
                entityDescriptor.getObjectMetadata().putAll((Iterable)keyAuthority.getObjectMetadata().get(PKIXValidationInformation.class));
            }
        }
    }

    @Nonnull
    protected List<XMLObject> getKeyAuthorities(@Nonnull EntitiesDescriptor entitiesDescriptor) {
        Extensions extensions = entitiesDescriptor.getExtensions();
        if (extensions == null) {
            return Collections.emptyList();
        }
        List keyAuthorities = extensions.getUnknownXMLObjects(KeyAuthority.DEFAULT_ELEMENT_NAME);
        if (keyAuthorities == null) {
            return Collections.emptyList();
        }
        return keyAuthorities;
    }
}

