/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.attribute.mapping.impl;

import com.google.common.base.Objects;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.attribute.IdPAttributeValue;
import net.shibboleth.idp.attribute.XMLObjectAttributeValue;
import net.shibboleth.idp.saml.attribute.mapping.AbstractSAMLAttributeValueMapper;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.opensaml.core.xml.XMLObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XmlObjectAttributeValueMapper
extends AbstractSAMLAttributeValueMapper {
    private Logger log = LoggerFactory.getLogger(XmlObjectAttributeValueMapper.class);
    private boolean includeAttributeValue;

    public boolean isIncludeAttributeValue() {
        return this.includeAttributeValue;
    }

    public void setIncludeAttributeValue(boolean doInclude) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.includeAttributeValue = doInclude;
    }

    @Nullable
    protected IdPAttributeValue decodeValue(@Nonnull XMLObject object) {
        Constraint.isNotNull((Object)object, (String)"Object supplied to must not be null");
        if (this.includeAttributeValue) {
            return new XMLObjectAttributeValue(object);
        }
        List children = object.getOrderedChildren();
        if (null == children || children.isEmpty()) {
            this.log.debug("{} attribute had no XML children, ignored", (Object)this.getLogPrefix());
            return null;
        }
        if (children.size() > 1) {
            this.log.debug("{} attribute has more than one child, returning first value only", (Object)this.getLogPrefix());
        }
        XMLObject child = (XMLObject)children.get(0);
        this.log.debug("{} returning value of type {}", (Object)this.getLogPrefix(), (Object)child.getClass().toString());
        return new XMLObjectAttributeValue(child);
    }

    @Nonnull
    protected String getAttributeTypeName() {
        return "XMLObject";
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj instanceof XmlObjectAttributeValueMapper) {
            XmlObjectAttributeValueMapper other = (XmlObjectAttributeValueMapper)((Object)obj);
            return this.isIncludeAttributeValue() == other.isIncludeAttributeValue();
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{((Object)((Object)this)).getClass(), this.isIncludeAttributeValue()});
    }
}

