/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.attribute.mapping.impl;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import net.shibboleth.idp.attribute.IdPAttribute;
import net.shibboleth.idp.attribute.resolver.AttributeResolver;
import net.shibboleth.idp.saml.attribute.mapping.AttributesMapper;
import net.shibboleth.idp.saml.attribute.mapping.impl.SAML2AttributesMapper;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.service.ReloadableService;
import net.shibboleth.utilities.java.support.service.ServiceableComponent;
import org.joda.time.DateTime;
import org.opensaml.saml.saml2.core.Attribute;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class SAML2AttributesMapperService
implements AttributesMapper<Attribute, IdPAttribute> {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(SAML2AttributesMapperService.class);
    @Nonnull
    private final ReloadableService<AttributeResolver> attributeResolverService;
    @Nonnull
    private boolean refreshFailed;
    @Nullable
    private SAML2AttributesMapper attributesMapper;
    @Nullable
    private DateTime lastReload;

    public SAML2AttributesMapperService(@Nonnull ReloadableService<AttributeResolver> resolverService) {
        this.attributeResolverService = (ReloadableService)Constraint.isNotNull(resolverService, (String)"AttributeResolver cannot be null");
    }

    @Nonnull
    @NonnullElements
    public Multimap<String, IdPAttribute> mapAttributes(@Nonnull @NonnullElements List<Attribute> prototypes) {
        SAML2AttributesMapper mapper = this.getMapper();
        if (null == mapper) {
            this.log.error("No AttributeMapper available, returning nothing");
            return ArrayListMultimap.create();
        }
        return mapper.mapAttributes(prototypes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private SAML2AttributesMapper getMapper() {
        if (this.lastReload != null && this.lastReload.equals((Object)this.attributeResolverService.getLastSuccessfulReloadInstant())) {
            return this.attributesMapper;
        }
        ServiceableComponent component = null;
        SAML2AttributesMapper am = null;
        try {
            DateTime when = this.attributeResolverService.getLastSuccessfulReloadInstant();
            component = this.attributeResolverService.getServiceableComponent();
            if (null == component) {
                if (!this.refreshFailed) {
                    this.log.error("Invalid AttributeResolver configuration");
                }
                this.refreshFailed = true;
            } else {
                AttributeResolver attributeResolver = (AttributeResolver)component.getComponent();
                am = new SAML2AttributesMapper(attributeResolver);
                this.refreshFailed = false;
                this.lastReload = when;
            }
        }
        finally {
            if (null != component) {
                component.unpinComponent();
            }
        }
        try {
            if (null != am) {
                am.initialize();
            }
        }
        catch (ComponentInitializationException e) {
            this.log.error("Error initializing AttributeMapper", (Throwable)e);
        }
        this.attributesMapper = am;
        return am;
    }
}

