/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.attribute.principalconnector.impl;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.Collections;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.authn.context.SubjectCanonicalizationContext;
import net.shibboleth.idp.saml.nameid.NameDecoderException;
import net.shibboleth.idp.saml.nameid.NameIDDecoder;
import net.shibboleth.idp.saml.nameid.NameIdentifierDecoder;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.annotation.constraint.NotLive;
import net.shibboleth.utilities.java.support.annotation.constraint.NullableElements;
import net.shibboleth.utilities.java.support.annotation.constraint.Unmodifiable;
import net.shibboleth.utilities.java.support.component.AbstractIdentifiableInitializableComponent;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import org.opensaml.saml.saml1.core.NameIdentifier;
import org.opensaml.saml.saml2.core.NameID;

public class PrincipalConnector
extends AbstractIdentifiableInitializableComponent
implements NameIdentifierDecoder,
NameIDDecoder {
    @Nonnull
    private final NameIDDecoder nameIDDecoder;
    @Nonnull
    private final NameIdentifierDecoder nameIdentifierDecoder;
    @Nonnull
    @NotEmpty
    private final String format;
    @Nonnull
    private Collection<String> relyingParties;

    public PrincipalConnector(@Nonnull NameIDDecoder saml2Decoder, @Nonnull NameIdentifierDecoder saml1Decoder, @Nonnull @NotEmpty String theFormat) {
        this.nameIDDecoder = (NameIDDecoder)Constraint.isNotNull((Object)saml2Decoder, (String)"NameIDDecoder cannot be null");
        this.nameIdentifierDecoder = (NameIdentifierDecoder)Constraint.isNotNull((Object)saml1Decoder, (String)"NameIdentifierDecoder cannot be null");
        this.format = (String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)theFormat), (String)"Name identifier format cannot be empty or null");
        this.relyingParties = Collections.emptySet();
    }

    @Nonnull
    public NameIDDecoder getNameIDDecoder() {
        return this.nameIDDecoder;
    }

    @Nonnull
    public NameIdentifierDecoder getNameIdentifierDecoder() {
        return this.nameIdentifierDecoder;
    }

    @Nonnull
    public String getFormat() {
        return this.format;
    }

    @Nonnull
    @NonnullElements
    @NotLive
    @Unmodifiable
    public Collection<String> getRelyingParties() {
        return this.relyingParties;
    }

    public void setRelyingParties(@Nullable @NullableElements Collection<String> rps) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        if (null != rps) {
            this.relyingParties = ImmutableSet.copyOf((Iterable)Iterables.filter(rps, (Predicate)Predicates.notNull()));
        }
    }

    public boolean requesterMatches(@Nullable String requester) {
        return null == requester || this.relyingParties.isEmpty() || this.relyingParties.contains(requester);
    }

    @Nullable
    public String decode(@Nonnull SubjectCanonicalizationContext c14nContext, @Nonnull NameID nameID) throws NameDecoderException {
        return this.nameIDDecoder.decode(c14nContext, nameID);
    }

    @Nullable
    public String decode(@Nonnull SubjectCanonicalizationContext c14nContext, @Nonnull NameIdentifier nameIdentifier) throws NameDecoderException {
        return this.nameIdentifierDecoder.decode(c14nContext, nameIdentifier);
    }
}

