/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.nameid.impl;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.attribute.IdPAttribute;
import net.shibboleth.idp.attribute.IdPAttributeValue;
import net.shibboleth.idp.attribute.ScopedStringAttributeValue;
import net.shibboleth.idp.attribute.StringAttributeValue;
import net.shibboleth.idp.attribute.XMLObjectAttributeValue;
import net.shibboleth.idp.attribute.context.AttributeContext;
import net.shibboleth.idp.profile.context.RelyingPartyContext;
import net.shibboleth.idp.profile.context.navigate.RelyingPartyIdLookupFunction;
import net.shibboleth.idp.profile.context.navigate.ResponderIdLookupFunction;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.annotation.constraint.ThreadSafeAfterInit;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.saml.common.SAMLException;
import org.opensaml.saml.saml2.core.NameID;
import org.opensaml.saml.saml2.profile.AbstractSAML2NameIDGenerator;
import org.opensaml.saml.saml2.profile.SAML2ObjectSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafeAfterInit
public class AttributeSourcedSAML2NameIDGenerator
extends AbstractSAML2NameIDGenerator {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(AttributeSourcedSAML2NameIDGenerator.class);
    @Nonnull
    private Function<ProfileRequestContext, AttributeContext> attributeContextLookupStrategy = Functions.compose((Function)new ChildContextLookup(AttributeContext.class), (Function)new ChildContextLookup(RelyingPartyContext.class));
    private char delimiter = (char)64;
    @Nonnull
    @NonnullElements
    private List<String> attributeSourceIds = Collections.emptyList();

    public AttributeSourcedSAML2NameIDGenerator() {
        this.setDefaultIdPNameQualifierLookupStrategy((Function)new ResponderIdLookupFunction());
        this.setDefaultSPNameQualifierLookupStrategy((Function)new RelyingPartyIdLookupFunction());
    }

    public void setAttributeContextLookupStrategy(@Nonnull Function<ProfileRequestContext, AttributeContext> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.attributeContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"AttributeContext lookup strategy cannot be null");
    }

    public void setScopedDelimiter(char ch) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.delimiter = ch;
    }

    public void setAttributeSourceIds(@Nonnull @NonnullElements List<String> ids) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        Constraint.isNotNull(ids, (String)"Attribute ID collection cannot be null");
        this.attributeSourceIds = Lists.newArrayList((Iterable)Collections2.filter(ids, (Predicate)Predicates.notNull()));
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.attributeSourceIds.isEmpty()) {
            throw new ComponentInitializationException("Attribute source ID list cannot be empty");
        }
    }

    @Nullable
    protected NameID doGenerate(@Nonnull ProfileRequestContext profileRequestContext) throws SAMLException {
        AttributeContext attributeCtx = (AttributeContext)this.attributeContextLookupStrategy.apply((Object)profileRequestContext);
        if (attributeCtx == null) {
            this.log.warn("Unable to locate AttributeContext");
            return null;
        }
        Map attributes = attributeCtx.getIdPAttributes();
        for (String sourceId : this.attributeSourceIds) {
            IdPAttribute attribute = (IdPAttribute)attributes.get(sourceId);
            if (attribute == null) continue;
            List values = attribute.getValues();
            for (IdPAttributeValue value : values) {
                if (!(value instanceof XMLObjectAttributeValue) || !(value.getValue() instanceof NameID)) continue;
                if (SAML2ObjectSupport.areNameIDFormatsEquivalent((String)this.getFormat(), (String)((NameID)value.getValue()).getFormat())) {
                    this.log.info("Returning NameID from XMLObject-valued attribute {}", (Object)sourceId);
                    return (NameID)value.getValue();
                }
                this.log.debug("Attribute {} value was NameID, but Format did not match", (Object)sourceId);
            }
        }
        return super.doGenerate(profileRequestContext);
    }

    @Nullable
    protected String getIdentifier(@Nonnull ProfileRequestContext profileRequestContext) throws SAMLException {
        AttributeContext attributeCtx = (AttributeContext)this.attributeContextLookupStrategy.apply((Object)profileRequestContext);
        Map attributes = attributeCtx.getIdPAttributes();
        for (String sourceId : this.attributeSourceIds) {
            this.log.debug("Checking for source attribute {}", (Object)sourceId);
            IdPAttribute attribute = (IdPAttribute)attributes.get(sourceId);
            if (attribute == null) continue;
            List values = attribute.getValues();
            for (IdPAttributeValue value : values) {
                if (value instanceof ScopedStringAttributeValue) {
                    this.log.debug("Generating NameID from Scoped String-valued attribute {}", (Object)sourceId);
                    return ((ScopedStringAttributeValue)value).getValue() + this.delimiter + ((ScopedStringAttributeValue)value).getScope();
                }
                if (value instanceof StringAttributeValue) {
                    this.log.debug("Generating NameID from String-valued attribute {}", (Object)sourceId);
                    return ((StringAttributeValue)value).getValue();
                }
                this.log.warn("Unrecognized attribute value type: {}", (Object)value.getClass().getName());
            }
        }
        this.log.info("Attribute sources {} did not produce a usable identifier", this.attributeSourceIds);
        return null;
    }
}

